/*
 * Decompiled with CFR 0.152.
 */
package com.evanlennick.retry4j.backoff;

import com.evanlennick.retry4j.backoff.BackoffStrategy;
import java.time.Duration;

public class ExponentialBackoffStrategy
implements BackoffStrategy {
    @Override
    public long getMillisToWait(int numberOfTriesFailed, Duration delayBetweenAttempts) {
        long exponentialMultiplier = (long)((Math.pow(2.0, numberOfTriesFailed) - 1.0) / 2.0);
        long millisToWait = exponentialMultiplier * delayBetweenAttempts.toMillis();
        return millisToWait;
    }
}

