/*
 * Decompiled with CFR 0.152.
 */
package com.evanlennick.retry4j.backoff;

import com.evanlennick.retry4j.backoff.BackoffStrategy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class FibonacciBackoffStrategy
implements BackoffStrategy {
    private List<Integer> fibonacciNumbers = new ArrayList<Integer>();
    public static final int MAX_NUM_OF_FIB_NUMBERS = 25;

    public FibonacciBackoffStrategy() {
        this.fibonacciNumbers.add(0);
        this.fibonacciNumbers.add(1);
        for (int i = 0; i < 25; ++i) {
            int nextFibNum = this.fibonacciNumbers.get(i) + this.fibonacciNumbers.get(i + 1);
            this.fibonacciNumbers.add(nextFibNum);
        }
    }

    @Override
    public long getMillisToWait(int numberOfTriesFailed, Duration delayBetweenAttempts) {
        int fibNumber;
        try {
            fibNumber = this.fibonacciNumbers.get(numberOfTriesFailed);
        }
        catch (IndexOutOfBoundsException e) {
            fibNumber = this.fibonacciNumbers.get(24);
        }
        return delayBetweenAttempts.toMillis() * (long)fibNumber;
    }

    public List<Integer> getFibonacciNumbers() {
        return this.fibonacciNumbers;
    }
}

