/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.evasion.plugin.content;

import com.evasion.entity.content.Contribution;
import com.evasion.exception.PersistenceViolationException;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author sebastien
 */
public class ContributionManager {

    /**
     * LOGGER.
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(
            ContributionManager.class);

    private EntityManager em;

    public ContributionManager(EntityManager em) {
        this.em = em;
    }

    public Contribution save(final Contribution contribution) throws PersistenceViolationException {
        Contribution result = null;
        try {
            result = em.merge(contribution);
        } catch (Exception e) {
            LOGGER.debug("Erreur de sauvegarde de la contribution: ", e);
            throw new PersistenceViolationException("Erreur dans la validation d'une contribution", e.fillInStackTrace());
        }
        return result;
    }
}
