/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.evasion.plugin.content;

import com.evasion.AbstractEJBModule;
import com.evasion.ejb.local.StaticPageManagerLocal;
import com.evasion.ejb.remote.StaticPageManagerRemote;
import com.evasion.entity.content.StaticPage;
import com.evasion.exception.PersistenceViolationException;
import com.evasion.module.common.ICommonModule;
import java.util.Date;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author sebastien.glon
 */
@Stateless
@Local(value = StaticPageManagerLocal.class)
@Remote(value= StaticPageManagerRemote.class)
public class StaticPageManager extends AbstractEJBModule implements StaticPageManagerLocal, StaticPageManagerRemote {

    /** LOGGER  */
    private static final Logger LOGGER = LoggerFactory.getLogger(
            StaticPageManager.class);
    @EJB
    private ICommonModule userService;
    
    @PersistenceContext(unitName = "EvasionPU")
    private EntityManager em;

    protected StaticPageManager(EntityManager em) {
        this.em = em;
    }

    public StaticPageManager() {
    }

    /**
     * {@inheritDoc }
     */
    @Override
    public StaticPage savePage(StaticPage page) throws PersistenceViolationException {
        StaticPage newPage = page;
        try {
        newPage.setUserName(this.getPrinciaplUserName());
        
        newPage.setDateMaj(new Date());
        
            if (page.getId() == null) {
                em.persist(newPage);
            } else {
                newPage = em.merge(newPage);
            }
            em.flush();
        } catch (Exception e) {// @TODO revoir la gestion des erreurs car une erreur sur le username est masqué.
            throw new PersistenceViolationException("Erreur dans la validation de la page statique", e.fillInStackTrace());
        }
        return newPage;
    }

    /**
     * {@inheritDoc }
     */
    @Override
    public StaticPage createPage(StaticPage page, String userName) throws PersistenceViolationException {
        if (page.getId() != null) {
            throw new PersistenceViolationException("Cette méthode ne peut être utilisé pour une page déja existente");
        }
        return savePage(page);
    }

    /**
     * {@inheritDoc }
     */
    @Override
    public void deletePage(StaticPage p) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * {@inheritDoc }
     */
    @Override
    public List<StaticPage> listAll() {
        List<StaticPage> list;
        Query query = em.createNamedQuery(StaticPage.FIND_ALL);
        list = query.getResultList();
//        for (StaticPage page : list) {
//            em.refresh(page);
//        }
//        list.size();
        return list;
    }

    /**
     * {@inheritDoc }
     */
    @TransactionAttribute(TransactionAttributeType.NEVER)
    @Override
    public StaticPage getStaticPage(Long id) {
        StaticPage page = em.find(StaticPage.class, id);
        if (page != null && page.getCorps() != null) {
            page.getCorps().length();
        }
        return page;
    }
}
