/*
 * Decompiled with CFR 0.152.
 */
package com.evasion.plugin.content;

import com.evasion.AbstractEJBModule;
import com.evasion.ejb.local.StaticPageManagerLocal;
import com.evasion.ejb.remote.StaticPageManagerRemote;
import com.evasion.entity.content.StaticPage;
import com.evasion.exception.PersistenceViolationException;
import com.evasion.module.common.ICommonModule;
import java.util.Date;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@Local(value={StaticPageManagerLocal.class})
@Remote(value={StaticPageManagerRemote.class})
public class StaticPageManager
extends AbstractEJBModule
implements StaticPageManagerLocal,
StaticPageManagerRemote {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticPageManager.class);
    @EJB
    private ICommonModule userService;
    @PersistenceContext(unitName="EvasionPU")
    private EntityManager em;

    protected StaticPageManager(EntityManager em) {
        this.em = em;
    }

    public StaticPageManager() {
    }

    public StaticPage savePage(StaticPage page) throws PersistenceViolationException {
        StaticPage newPage = page;
        try {
            newPage.setUserName(this.getPrinciaplUserName());
            newPage.setDateMaj(new Date());
            if (page.getId() == null) {
                this.em.persist((Object)newPage);
            } else {
                newPage = (StaticPage)this.em.merge((Object)newPage);
            }
            this.em.flush();
        }
        catch (Exception e) {
            throw new PersistenceViolationException("Erreur dans la validation de la page statique", e.fillInStackTrace());
        }
        return newPage;
    }

    public StaticPage createPage(StaticPage page, String userName) throws PersistenceViolationException {
        if (page.getId() != null) {
            throw new PersistenceViolationException("Cette m\u00e9thode ne peut \u00eatre utilis\u00e9 pour une page d\u00e9ja existente");
        }
        return this.savePage(page);
    }

    public void deletePage(StaticPage p) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<StaticPage> listAll() {
        Query query = this.em.createNamedQuery("findAllStaticPage");
        List list = query.getResultList();
        return list;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public StaticPage getStaticPage(Long id) {
        StaticPage page = (StaticPage)this.em.find(StaticPage.class, (Object)id);
        if (page != null && page.getCorps() != null) {
            page.getCorps().length();
        }
        return page;
    }
}

