/*
 * Decompiled with CFR 0.152.
 */
package com.evento.common.messaging.consumer;

import com.evento.common.messaging.bus.EventoServer;
import com.evento.common.messaging.consumer.EventConsumer;
import com.evento.common.messaging.consumer.EventFetchRequest;
import com.evento.common.messaging.consumer.EventFetchResponse;
import com.evento.common.messaging.consumer.EventLastSequenceNumberRequest;
import com.evento.common.messaging.consumer.EventLastSequenceNumberResponse;
import com.evento.common.messaging.consumer.SagaEventConsumer;
import com.evento.common.messaging.consumer.StoredSagaState;
import com.evento.common.modeling.messaging.dto.PublishedEvent;
import com.evento.common.modeling.state.SagaState;
import com.evento.common.performance.PerformanceService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ConsumerStateStore {
    protected final EventoServer eventoServer;
    private final PerformanceService performanceService;
    private final ObjectMapper objectMapper;
    private final Executor observerExecutor;

    protected ConsumerStateStore(EventoServer eventoServer, PerformanceService performanceService, ObjectMapper objectMapper, Executor observerExecutor) {
        this.eventoServer = eventoServer;
        this.performanceService = performanceService;
        this.objectMapper = objectMapper;
        this.observerExecutor = observerExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int consumeEventsForProjector(String consumerId, String projectorName, String context, EventConsumer projectorEventConsumer, int fetchSize) throws Throwable {
        int consumedEventCount = 0;
        if (!this.enterExclusiveZone(consumerId)) return -1;
        try {
            Long lastEventSequenceNumber = this.getLastEventSequenceNumber(consumerId);
            if (lastEventSequenceNumber == null) {
                lastEventSequenceNumber = 0L;
            }
            EventFetchResponse resp = (EventFetchResponse)this.eventoServer.request(new EventFetchRequest(context, lastEventSequenceNumber, fetchSize, projectorName)).get();
            for (PublishedEvent event : resp.getEvents()) {
                Instant start = Instant.now();
                try {
                    projectorEventConsumer.consume(event);
                }
                catch (Exception e) {
                    throw new RuntimeException("Event consumption Error for projection %s and event %s".formatted(projectorName, event.getEventName()), e);
                }
                this.setLastEventSequenceNumber(consumerId, event.getEventSequenceNumber());
                ++consumedEventCount;
                this.performanceService.sendServiceTimeMetric(this.eventoServer.getBundleId(), projectorName, event.getEventMessage(), start);
            }
            return consumedEventCount;
        }
        finally {
            this.leaveExclusiveZone(consumerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int consumeEventsForObserver(String consumerId, String observerName, String context, EventConsumer observerEventConsumer, int fetchSize) throws Throwable {
        int consumedEventCount = 0;
        if (this.enterExclusiveZone(consumerId)) {
            try {
                long lastEventSequenceNumber = this.getLastEventSequenceNumberSagaOrHead(consumerId);
                EventFetchResponse resp = (EventFetchResponse)this.eventoServer.request(new EventFetchRequest(context, lastEventSequenceNumber, fetchSize, observerName)).get();
                for (PublishedEvent event : resp.getEvents()) {
                    Instant start = Instant.now();
                    this.observerExecutor.execute(() -> {
                        try {
                            observerEventConsumer.consume(event);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Event consumption Error for consumer %s and event %s".formatted(observerName, event.getEventName()), e);
                        }
                    });
                    this.setLastEventSequenceNumber(consumerId, event.getEventSequenceNumber());
                    ++consumedEventCount;
                    this.performanceService.sendServiceTimeMetric(this.eventoServer.getBundleId(), observerName, event.getEventMessage(), start);
                }
            }
            finally {
                this.leaveExclusiveZone(consumerId);
            }
        } else {
            return -1;
        }
        return consumedEventCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int consumeEventsForSaga(String consumerId, String sagaName, String context, SagaEventConsumer sagaEventConsumer, int fetchSize) throws Throwable {
        int consumedEventCount = 0;
        if (!this.enterExclusiveZone(consumerId)) return -1;
        try {
            long lastEventSequenceNumber = this.getLastEventSequenceNumberSagaOrHead(consumerId);
            EventFetchResponse resp = (EventFetchResponse)this.eventoServer.request(new EventFetchRequest(context, lastEventSequenceNumber, fetchSize, sagaName)).get();
            for (PublishedEvent event : resp.getEvents()) {
                Instant start = Instant.now();
                AtomicReference sagaStateId = new AtomicReference();
                try {
                    SagaState newState = sagaEventConsumer.consume((name, associationProperty, associationValue) -> {
                        StoredSagaState state = this.getSagaState(name, associationProperty, associationValue);
                        sagaStateId.set(state.getId());
                        return state.getState();
                    }, event);
                    if (newState != null) {
                        if (newState.isEnded()) {
                            this.removeSagaState((Long)sagaStateId.get());
                        } else {
                            this.setSagaState((Long)sagaStateId.get(), sagaName, newState);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Event consumption Error for saga %s and event %s".formatted(sagaName, event.getEventName()), e);
                }
                this.setLastEventSequenceNumber(consumerId, event.getEventSequenceNumber());
                ++consumedEventCount;
                this.performanceService.sendServiceTimeMetric(this.eventoServer.getBundleId(), sagaName, event.getEventMessage(), start);
            }
            return consumedEventCount;
        }
        finally {
            this.leaveExclusiveZone(consumerId);
        }
    }

    protected long getLastEventSequenceNumberSagaOrHead(String consumerId) throws Exception {
        Long last = this.getLastEventSequenceNumber(consumerId);
        if (last == null) {
            long head = ((EventLastSequenceNumberResponse)this.eventoServer.request(new EventLastSequenceNumberRequest()).get()).getNumber();
            this.setLastEventSequenceNumber(consumerId, head);
            return head;
        }
        return last;
    }

    protected abstract void removeSagaState(Long var1) throws Exception;

    protected abstract void leaveExclusiveZone(String var1);

    protected abstract boolean enterExclusiveZone(String var1);

    protected abstract Long getLastEventSequenceNumber(String var1) throws Exception;

    protected abstract void setLastEventSequenceNumber(String var1, Long var2) throws Exception;

    protected abstract StoredSagaState getSagaState(String var1, String var2, String var3) throws Exception;

    protected abstract void setSagaState(Long var1, String var2, SagaState var3) throws Exception;

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

