/*
 * Decompiled with CFR 0.152.
 */
package com.evento.common.messaging.consumer.impl;

import com.evento.common.messaging.bus.EventoServer;
import com.evento.common.messaging.consumer.ConsumerStateStore;
import com.evento.common.messaging.consumer.StoredSagaState;
import com.evento.common.modeling.state.SagaState;
import com.evento.common.performance.PerformanceService;
import com.evento.common.serialization.ObjectMapperUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class InMemoryConsumerStateStore
extends ConsumerStateStore {
    private final Map<Object, Lock> lockRegistry = new HashMap<Object, Lock>();
    private final Map<String, Long> lastEventSequenceNumberRepository = new HashMap<String, Long>();
    private final Map<Long, Map.Entry<String, SagaState>> sagaStateRepository = new HashMap<Long, Map.Entry<String, SagaState>>();
    private final AtomicInteger sagaCounter = new AtomicInteger(1);

    public InMemoryConsumerStateStore(EventoServer eventoServer, PerformanceService performanceService) {
        this(eventoServer, performanceService, ObjectMapperUtils.getPayloadObjectMapper(), Executors.newVirtualThreadPerTaskExecutor());
    }

    public InMemoryConsumerStateStore(EventoServer eventoServer, PerformanceService performanceService, ObjectMapper objectMapper, Executor observerExecutor) {
        super(eventoServer, performanceService, objectMapper, observerExecutor);
    }

    @Override
    protected void removeSagaState(Long sagaId) {
        this.sagaStateRepository.remove(sagaId);
    }

    @Override
    protected void leaveExclusiveZone(String consumerId) {
        this.obtain(consumerId).unlock();
    }

    @Override
    protected boolean enterExclusiveZone(String consumerId) {
        return this.obtain(consumerId).tryLock();
    }

    protected synchronized Lock obtain(Object lockKey) {
        if (!this.lockRegistry.containsKey(lockKey)) {
            this.lockRegistry.put(lockKey, new ReentrantLock());
        }
        return this.lockRegistry.get(lockKey);
    }

    @Override
    protected Long getLastEventSequenceNumber(String consumerId) {
        return this.lastEventSequenceNumberRepository.getOrDefault(consumerId, null);
    }

    @Override
    protected void setLastEventSequenceNumber(String consumerId, Long eventSequenceNumber) {
        this.lastEventSequenceNumberRepository.put(consumerId, eventSequenceNumber);
    }

    @Override
    protected StoredSagaState getSagaState(String sagaName, String associationProperty, String associationValue) {
        return this.sagaStateRepository.entrySet().stream().filter(s -> ((String)((Map.Entry)s.getValue()).getKey()).equals(sagaName)).filter(s -> Objects.equals(associationValue, ((SagaState)((Map.Entry)s.getValue()).getValue()).getAssociation(associationProperty))).findFirst().map(s -> new StoredSagaState((Long)s.getKey(), (SagaState)((Map.Entry)s.getValue()).getValue())).orElseGet(() -> new StoredSagaState(null, null));
    }

    @Override
    protected void setSagaState(Long id, final String sagaName, final SagaState sagaState) {
        this.sagaStateRepository.put(Objects.requireNonNullElseGet(id, () -> this.sagaCounter.getAndIncrement()), new Map.Entry<String, SagaState>(this){

            @Override
            public String getKey() {
                return sagaName;
            }

            @Override
            public SagaState getValue() {
                return sagaState;
            }

            @Override
            public SagaState setValue(SagaState value) {
                return sagaState;
            }
        });
    }
}

