/*
 * Decompiled with CFR 0.152.
 */
package com.evento.common.messaging.gateway;

import com.evento.common.messaging.bus.EventoServer;
import com.evento.common.messaging.gateway.CommandGateway;
import com.evento.common.modeling.messaging.message.application.CommandMessage;
import com.evento.common.modeling.messaging.message.application.DomainCommandMessage;
import com.evento.common.modeling.messaging.message.application.Message;
import com.evento.common.modeling.messaging.message.application.Metadata;
import com.evento.common.modeling.messaging.message.application.ServiceCommandMessage;
import com.evento.common.modeling.messaging.payload.Command;
import com.evento.common.modeling.messaging.payload.DomainCommand;
import com.evento.common.modeling.messaging.payload.ServiceCommand;
import com.evento.common.serialization.ObjectMapperUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CommandGatewayImpl
implements CommandGateway {
    private final EventoServer eventoServer;

    public CommandGatewayImpl(EventoServer eventoServer) {
        this.eventoServer = eventoServer;
    }

    @Override
    public <R> R sendAndWait(Command command, Metadata metadata, Message<?> handledMessage) {
        try {
            return this.send(command, metadata, handledMessage).get();
        }
        catch (CompletionException | ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R> R sendAndWait(Command command, Metadata metadata, Message<?> handledMessage, long timeout, TimeUnit unit) {
        try {
            return this.send(command, metadata, handledMessage).get(timeout, unit);
        }
        catch (CompletionException | ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R> CompletableFuture<R> send(Command command, Metadata metadata, Message<?> handledMessage) {
        try {
            CommandMessage message = command instanceof DomainCommand ? new DomainCommandMessage((DomainCommand)command) : new ServiceCommandMessage((ServiceCommand)command);
            message.setMetadata(metadata);
            return this.eventoServer.request(message).thenApply(e -> {
                try {
                    return (Serializable)ObjectMapperUtils.getPayloadObjectMapper().readValue(e.toString(), Serializable.class);
                }
                catch (JsonProcessingException ex) {
                    throw new CompletionException(ex);
                }
            });
        }
        catch (Exception e2) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(e2);
            return future;
        }
    }
}

