/*
 * Decompiled with CFR 0.152.
 */
package com.evento.common.messaging.gateway;

import com.evento.common.messaging.bus.EventoServer;
import com.evento.common.messaging.gateway.QueryGateway;
import com.evento.common.modeling.messaging.message.application.Message;
import com.evento.common.modeling.messaging.message.application.Metadata;
import com.evento.common.modeling.messaging.message.application.QueryMessage;
import com.evento.common.modeling.messaging.payload.Query;
import com.evento.common.modeling.messaging.query.QueryResponse;
import com.evento.common.modeling.messaging.query.SerializedQueryResponse;
import java.util.concurrent.CompletableFuture;

public class QueryGatewayImpl
implements QueryGateway {
    private final EventoServer eventoServer;

    public QueryGatewayImpl(EventoServer eventoServer) {
        this.eventoServer = eventoServer;
    }

    @Override
    public <T extends QueryResponse<?>> CompletableFuture<T> query(Query<T> query, Metadata metadata, Message<?> handledMessage) {
        try {
            QueryMessage<Query<T>> message = new QueryMessage<Query<T>>(query);
            message.setMetadata(metadata);
            return this.eventoServer.request(message).thenApply(r -> (QueryResponse)((SerializedQueryResponse)r).getObject());
        }
        catch (Exception e) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(e);
            return future;
        }
    }
}

