/*
 * Decompiled with CFR 0.152.
 */
package com.evento.common.modeling.common;

import com.evento.common.serialization.ObjectMapperUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SerializedObject<T extends Serializable>
implements Serializable {
    private final transient Logger logger = LogManager.getLogger(this.getClass());
    private String serializedObject;
    private String objectClass;

    public SerializedObject(T object) {
        try {
            this.serializedObject = ObjectMapperUtils.getPayloadObjectMapper().writeValueAsString(object);
            if (object != null) {
                this.objectClass = object.getClass().toString();
            }
        }
        catch (JsonProcessingException e) {
            this.logger.error("Serialization failed", (Throwable)e);
            this.serializedObject = null;
        }
    }

    public SerializedObject() {
    }

    public String getSerializedObject() {
        return this.serializedObject;
    }

    public void setSerializedObject(String serializedObject) {
        this.serializedObject = serializedObject;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    public T getObject() {
        try {
            return (T)((Serializable)ObjectMapperUtils.getPayloadObjectMapper().readValue(this.serializedObject, Object.class));
        }
        catch (Exception e) {
            this.logger.error("Deserialization error", (Throwable)e);
            return null;
        }
    }

    public JsonNode getTree() {
        try {
            return ObjectMapperUtils.getPayloadObjectMapper().readTree(this.serializedObject);
        }
        catch (Exception e) {
            this.logger.error("Deserialization error", (Throwable)e);
            return null;
        }
    }
}

