/*
 * Decompiled with CFR 0.152.
 */
package com.evento.common.modeling.exceptions;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

public class ExceptionWrapper
implements Serializable {
    public String throwable;
    public String message;
    public StackTraceElement[] stackTrace;
    private ExceptionWrapper cause;

    public ExceptionWrapper(Throwable throwable) {
        this.throwable = throwable.getClass().getName();
        this.message = throwable.getMessage();
        this.stackTrace = throwable.getStackTrace();
        if (throwable.getCause() != null && throwable.getCause() != throwable) {
            this.cause = new ExceptionWrapper(throwable.getCause());
        }
    }

    public ExceptionWrapper() {
    }

    public String getThrowable() {
        return this.throwable;
    }

    public void setThrowable(String throwable) {
        this.throwable = throwable;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDetailMessage() {
        return this.message;
    }

    public void setDetailMessage(String message) {
        this.message = message;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    public ExceptionWrapper getCause() {
        return this.cause;
    }

    public ExceptionWrapper setCause(ExceptionWrapper cause) {
        this.cause = cause;
        return this;
    }

    public Exception toException() {
        try {
            if (this.cause != null) {
                Exception ex = (Exception)ClassLoader.getSystemClassLoader().loadClass(this.throwable).getConstructor(String.class, Throwable.class).newInstance(this.getMessage(), this.cause.toException());
                ex.setStackTrace(this.stackTrace);
                return ex;
            }
            Exception ex = (Exception)ClassLoader.getSystemClassLoader().loadClass(this.throwable).getConstructor(String.class).newInstance(this.getMessage());
            ex.setStackTrace(this.stackTrace);
            return ex;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            RuntimeException ex = new RuntimeException(this.throwable + ": " + this.getMessage());
            ex.setStackTrace(this.stackTrace);
            return ex;
        }
    }
}

