/*
 * Decompiled with CFR 0.152.
 */
package com.evento.common.modeling.messaging.message.application;

import com.evento.common.modeling.messaging.message.application.Message;
import com.evento.common.modeling.messaging.payload.Invocation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class InvocationMessage
extends Message<Invocation> {
    private String name;
    private String componentName;
    private String action;

    public InvocationMessage(Class<?> invoker, Method method, Object[] args) {
        super(InvocationMessage.generatePayload(method, args));
        this.name = invoker.getSimpleName() + "::" + method.getName();
        this.componentName = invoker.getSimpleName();
        this.action = method.getName();
    }

    private static Invocation generatePayload(Method method, Object[] args) {
        Invocation i = new Invocation();
        for (int j = 0; j < method.getParameters().length; ++j) {
            Parameter p = method.getParameters()[j];
            Object a = args[j];
            i.getArguments().put(p.getName(), a);
        }
        return i;
    }

    @Override
    public String getPayloadName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }
}

