/*
 * Decompiled with CFR 0.152.
 */
package com.evento.common.modeling.messaging.message.application;

import com.evento.common.modeling.messaging.message.application.Metadata;
import com.evento.common.modeling.messaging.message.application.SerializedPayload;
import com.evento.common.modeling.messaging.payload.Payload;
import java.io.Serializable;
import java.time.Instant;

public abstract class Message<T extends Payload>
implements Serializable {
    private SerializedPayload<T> serializedPayload;
    private long timestamp;
    private Metadata metadata;

    public Message(T payload) {
        this.serializedPayload = new SerializedPayload<T>(payload);
        this.timestamp = Instant.now().toEpochMilli();
    }

    public Message() {
    }

    public T getPayload() {
        return (T)((Payload)this.serializedPayload.getObject());
    }

    public void setPayload(T payload) {
        this.serializedPayload = new SerializedPayload<T>(payload);
    }

    public SerializedPayload<T> getSerializedPayload() {
        return this.serializedPayload;
    }

    public void setSerializedPayload(SerializedPayload<T> serializedPayload) {
        this.serializedPayload = serializedPayload;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public String getType() {
        return this.serializedPayload.getObjectClass();
    }

    public String getPayloadName() {
        String[] parts = this.getType().split("\\.");
        return parts[parts.length - 1];
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }
}

