/*
 * Decompiled with CFR 0.152.
 */
package com.evento.common.performance;

import com.evento.common.messaging.bus.EventoServer;
import com.evento.common.modeling.messaging.message.internal.ClusterNodeIsBoredMessage;
import com.evento.common.performance.ThreadCountAutoscalingProtocol;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AutoscalingProtocol {
    protected static final Logger logger = LogManager.getLogger(ThreadCountAutoscalingProtocol.class);
    private final EventoServer eventoServer;

    protected AutoscalingProtocol(EventoServer eventoServer) {
        this.eventoServer = eventoServer;
    }

    public abstract void arrival();

    public abstract void departure();

    protected void sendBoredSignal() throws Exception {
        this.eventoServer.send(new ClusterNodeIsBoredMessage(this.eventoServer.getBundleId(), this.eventoServer.getInstanceId()));
        logger.info("ClusterNodeIsBoredMessage sent by timer");
    }

    protected void sendSufferingSignal() throws Exception {
        this.eventoServer.send(new ClusterNodeIsBoredMessage(this.eventoServer.getBundleId(), this.eventoServer.getInstanceId()));
        logger.info("ClusterNodeIsSufferingMessage sent");
    }
}

