/*
 * Decompiled with CFR 0.152.
 */
package com.evento.common.performance;

import com.evento.common.modeling.messaging.message.application.Message;
import com.evento.common.performance.PerformanceInvocationsMessage;
import com.evento.common.performance.PerformanceServiceTimeMessage;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PerformanceService {
    private static final Logger logger = LogManager.getLogger(PerformanceService.class);
    public static final String EVENT_STORE = "event-store";
    public static final String EVENT_STORE_COMPONENT = "EventStore";
    public static final String GATEWAY_COMPONENT = "Gateway";
    public static final String SERVER = "server";
    protected final Executor executor = Executors.newSingleThreadExecutor();
    private final Random random = new Random();
    private double performanceRate;

    public PerformanceService(double rate) {
        this.performanceRate = rate;
    }

    public final void sendServiceTimeMetric(String bundle, String component, Message<?> message, Instant startTime) {
        if (this.random.nextDouble(0.0, 1.0) > this.performanceRate) {
            return;
        }
        long time = Instant.now().toEpochMilli();
        this.executor.execute(() -> {
            PerformanceServiceTimeMessage st = new PerformanceServiceTimeMessage(bundle, component, message.getPayloadName(), startTime.toEpochMilli(), time);
            try {
                this.sendServiceTimeMetricMessage(st);
            }
            catch (Exception e) {
                logger.error("Error during performance save", (Throwable)e);
            }
        });
    }

    protected abstract void sendServiceTimeMetricMessage(PerformanceServiceTimeMessage var1) throws Exception;

    public void setPerformanceRate(double performanceRate) {
        this.performanceRate = performanceRate;
    }

    public final void sendInvocationsMetric(String bundle, String component, Message<?> action, HashMap<String, AtomicInteger> invocationCounter) {
        if (this.random.nextDouble(0.0, 1.0) > this.performanceRate) {
            return;
        }
        this.executor.execute(() -> {
            try {
                HashMap<String, Integer> invocations = new HashMap<String, Integer>();
                for (Map.Entry e : invocationCounter.entrySet()) {
                    invocations.put((String)e.getKey(), ((AtomicInteger)e.getValue()).get());
                }
                PerformanceInvocationsMessage pi = new PerformanceInvocationsMessage(bundle, component, action.getPayloadName(), invocations);
                this.sendInvocationMetricMessage(pi);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    protected abstract void sendInvocationMetricMessage(PerformanceInvocationsMessage var1) throws Exception;
}

