/*
 * Decompiled with CFR 0.152.
 */
package com.evento.common.performance;

import com.evento.common.messaging.bus.EventoServer;
import com.evento.common.performance.AutoscalingProtocol;
import com.evento.common.utils.Sleep;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadCountAutoscalingProtocol
extends AutoscalingProtocol {
    private static final Logger logger = LogManager.getLogger(ThreadCountAutoscalingProtocol.class);
    private final int maxThreadCount;
    private final int minThreadCount;
    private final int maxOverflowCount;
    private final int maxUnderflowCount;
    private int threadCount = 0;
    private int overflowCount = 0;
    private int underflowCount = 0;
    private boolean suffering = false;
    private boolean bored = true;
    private long lastDepartureAt = 0L;
    private long lastDepartureCheck = 0L;
    private long boredSentDepartureTime = -1L;

    public ThreadCountAutoscalingProtocol(EventoServer eventoServer, int maxThreadCount, int minThreadCount, int maxOverflowCount, int maxUnderflowCount, long boredTimeout) {
        super(eventoServer);
        this.maxUnderflowCount = maxUnderflowCount;
        this.minThreadCount = minThreadCount;
        this.maxThreadCount = maxThreadCount;
        this.maxOverflowCount = maxOverflowCount;
        Thread t = new Thread(() -> {
            try {
                while (true) {
                    Sleep.apply(boredTimeout);
                    if (this.threadCount == 0 && this.lastDepartureAt == this.lastDepartureCheck && this.boredSentDepartureTime != this.lastDepartureAt) {
                        this.overflowCount = 0;
                        this.suffering = false;
                        this.bored = true;
                        this.sendBoredSignal();
                        this.boredSentDepartureTime = this.lastDepartureAt;
                    }
                    this.lastDepartureCheck = this.lastDepartureAt;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        t.setName("ThreadCountAutoscalingProtocol");
        t.start();
    }

    @Override
    public synchronized void arrival() {
        if (++this.threadCount >= this.minThreadCount) {
            this.underflowCount = 0;
            this.bored = false;
            if (this.threadCount > this.maxThreadCount && ++this.overflowCount >= this.maxOverflowCount && !this.suffering) {
                try {
                    this.sendSufferingSignal();
                }
                catch (Exception e) {
                    logger.error("Error sending suffering signal", (Throwable)e);
                }
                this.suffering = true;
            }
        }
        logger.debug("ARRIVAL: " + this.threadCount);
    }

    @Override
    public synchronized void departure() {
        if (--this.threadCount <= this.maxThreadCount) {
            this.overflowCount = 0;
            this.suffering = false;
            if (this.threadCount < this.minThreadCount && ++this.underflowCount >= this.maxUnderflowCount && !this.bored) {
                try {
                    this.sendBoredSignal();
                }
                catch (Exception e) {
                    logger.error("Error sending bored signal", (Throwable)e);
                }
                this.bored = true;
            }
        }
        this.lastDepartureAt = Instant.now().toEpochMilli();
        logger.debug("DEPARTURE: " + this.threadCount);
    }
}

