/*
 * Decompiled with CFR 0.152.
 */
package com.evento.parser.java;

import com.evento.common.modeling.messaging.payload.DomainCommand;
import com.evento.common.modeling.messaging.payload.DomainEvent;
import com.evento.common.modeling.messaging.payload.Query;
import com.evento.common.modeling.messaging.payload.ServiceCommand;
import com.evento.common.modeling.messaging.payload.ServiceEvent;
import com.evento.common.modeling.messaging.payload.View;
import com.evento.common.utils.FileUtils;
import com.evento.parser.BundleParser;
import com.evento.parser.java.JavaAggregateParser;
import com.evento.parser.java.JavaComponentParser;
import com.evento.parser.java.JavaInvokerParser;
import com.evento.parser.java.JavaObserverParser;
import com.evento.parser.java.JavaProjectionParser;
import com.evento.parser.java.JavaProjectorParser;
import com.evento.parser.java.JavaSagaParser;
import com.evento.parser.java.JavaServiceParser;
import com.evento.parser.model.BundleDescription;
import com.evento.parser.model.component.Component;
import com.evento.parser.model.component.Invoker;
import com.evento.parser.model.payload.Invocation;
import com.evento.parser.model.payload.PayloadDescription;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.Parser;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTImplementsList;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValuePair;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JavaBundleParser
implements BundleParser {
    private static final Logger logger = LogManager.getLogger(JavaBundleParser.class);
    public static final String EVENTO_BUNDLE_VERSION_PROPERTY = "evento.bundle.version";
    public static final String EVENTO_BUNDLE_NAME_PROPERTY = "evento.bundle.id";
    public static final String EVENTO_BUNDLE_AUTORUN_PROPERTY = "evento.bundle.autorun";
    public static final String EVENTO_BUNDLE_INSTANCES_MIN_PROPERTY = "evento.bundle.instances.min";
    public static final String EVENTO_BUNDLE_INSTANCES_MAX_PROPERTY = "evento.bundle.instances.max";

    @Override
    public BundleDescription parseDirectory(File directory, String repositoryRoot) throws Exception {
        LanguageVersionHandler java = LanguageRegistry.getLanguage((String)"Java").getDefaultVersion().getLanguageVersionHandler();
        Parser parser = java.getParser(java.getDefaultParserOptions());
        if (!directory.isDirectory()) {
            throw new RuntimeException("error.not.dir");
        }
        logger.info("Looking for components...");
        List components = (List)FileUtils.autoCloseWalk((Path)directory.toPath(), s -> s.filter(p -> p.toString().endsWith(".java")).filter(p -> !p.toString().toLowerCase().contains("test")).filter(p -> !p.toString().toLowerCase().contains("package-info")).map(p -> {
            try {
                Node node = parser.parse(p.getFileName().toString(), (Reader)new FileReader(p.toFile()));
                Component c = this.toComponent(node);
                if (c != null) {
                    c.setPath(p.toAbsolutePath().toString().replace(directory.getAbsolutePath(), repositoryRoot).replace("\\", "/"));
                }
                if (c != null) {
                    logger.info("Component found in: " + String.valueOf(p.toAbsolutePath()) + " (" + c.getLine() + ")");
                }
                return c;
            }
            catch (Exception e) {
                logger.error("Parsing error", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toList());
        logger.info("Total components detected: " + components.size());
        logger.info("Looking for payloads...");
        ArrayList<PayloadDescription> payloads = new ArrayList<PayloadDescription>((Collection)FileUtils.autoCloseWalk((Path)directory.toPath(), s -> s.filter(p -> p.toString().endsWith(".java")).filter(p -> !p.toString().toLowerCase().contains("package-info")).filter(p -> !p.toString().toLowerCase().contains("test")).map(p -> {
            try {
                Node node = parser.parse(p.getFileName().toString(), (Reader)new FileReader(p.toFile()));
                PayloadDescription pl = this.toPayload(node);
                if (pl != null) {
                    pl.setPath(p.toAbsolutePath().toString().replace(directory.getAbsolutePath(), repositoryRoot).replace("\\", "/"));
                }
                if (pl != null) {
                    logger.info("Payload found in: " + String.valueOf(p.toAbsolutePath()) + " (" + pl.getLine() + ")");
                }
                return pl;
            }
            catch (Exception e) {
                logger.error("Error parsing: " + String.valueOf(p.toAbsolutePath()), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toList()));
        payloads.addAll(components.stream().filter(c -> c instanceof Invoker).map(c -> (Invoker)c).flatMap(in -> in.getInvocationHandlers().stream().distinct().map(p -> {
            PayloadDescription pl = new PayloadDescription(((Invocation)p.getPayload()).getName(), ((Invocation)p.getPayload()).getDomain(), "Invocation", "{}", p.getLine());
            pl.setPath(in.getPath());
            logger.info("Invocation found in: " + in.getPath() + " (" + p.getLine() + ")");
            return pl;
        })).toList());
        logger.info("Total payloads detected: " + payloads.size());
        Integer bundleVersion = (Integer)FileUtils.autoCloseWalk((Path)directory.toPath(), s -> s.filter(p -> p.toString().endsWith(".properties")).mapToInt(p -> {
            try {
                Properties prop = new Properties();
                prop.load(new FileReader(p.toFile()));
                return Integer.parseInt(prop.getProperty(EVENTO_BUNDLE_VERSION_PROPERTY, "-1"));
            }
            catch (Exception e) {
                return -1;
            }
        }).filter(v -> v >= 0).findFirst().orElseThrow(() -> new Exception("Cannot find %s in a .property file".formatted(EVENTO_BUNDLE_VERSION_PROPERTY))));
        String bundleId = (String)FileUtils.autoCloseWalk((Path)directory.toPath(), s -> s.filter(p -> p.toString().endsWith(".properties")).map(p -> {
            try {
                Properties prop = new Properties();
                prop.load(new FileReader(p.toFile()));
                return prop.getProperty(EVENTO_BUNDLE_NAME_PROPERTY, null);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new Exception("Cannot find %s in a .property file".formatted(EVENTO_BUNDLE_NAME_PROPERTY))));
        Boolean autorun = (Boolean)FileUtils.autoCloseWalk((Path)directory.toPath(), s -> s.filter(p -> p.toString().endsWith(".properties")).map(p -> {
            try {
                Properties prop = new Properties();
                prop.load(new FileReader(p.toFile()));
                return Boolean.parseBoolean(prop.getProperty(EVENTO_BUNDLE_AUTORUN_PROPERTY, "false"));
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new Exception("Cannot find %s in a .property file".formatted(EVENTO_BUNDLE_NAME_PROPERTY))));
        Integer minInstances = (Integer)FileUtils.autoCloseWalk((Path)directory.toPath(), s -> s.filter(p -> p.toString().endsWith(".properties")).map(p -> {
            try {
                Properties prop = new Properties();
                prop.load(new FileReader(p.toFile()));
                int i = Integer.parseInt(prop.getProperty(EVENTO_BUNDLE_INSTANCES_MIN_PROPERTY, "0"));
                if (i == 0 && autorun.booleanValue()) {
                    return 1;
                }
                return i;
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new Exception("Cannot find %s in a .property file".formatted(EVENTO_BUNDLE_NAME_PROPERTY))));
        Integer maxInstances = (Integer)FileUtils.autoCloseWalk((Path)directory.toPath(), s -> s.filter(p -> p.toString().endsWith(".properties")).map(p -> {
            try {
                Properties prop = new Properties();
                prop.load(new FileReader(p.toFile()));
                return Integer.parseInt(prop.getProperty(EVENTO_BUNDLE_INSTANCES_MAX_PROPERTY, "64"));
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new Exception("Cannot find %s in a .property file".formatted(EVENTO_BUNDLE_NAME_PROPERTY))));
        AtomicReference bundleDetail = new AtomicReference();
        AtomicReference bundleDescription = new AtomicReference();
        try (Stream<Path> s2 = Files.walk(directory.toPath(), new FileVisitOption[0]);){
            s2.filter(p -> p.toString().endsWith(".md")).forEach(p -> {
                String name = p.getFileName().toString().replace(".md", "");
                for (Component component : components) {
                    if (!component.getComponentName().equals(name)) continue;
                    try {
                        String[] content = Files.readString(p).split("--detail");
                        component.setDescription(content[0].trim());
                        if (content.length > 1) {
                            component.setDetail(content[1].trim());
                        }
                        return;
                    }
                    catch (IOException content) {
                    }
                }
                for (PayloadDescription payloadDescription : payloads) {
                    if (!payloadDescription.getName().equals(name)) continue;
                    try {
                        String[] content = Files.readString(p).split("--detail");
                        payloadDescription.setDescription(content[0].trim());
                        if (content.length > 1) {
                            payloadDescription.setDetail(content[1].trim());
                        }
                        return;
                    }
                    catch (IOException iOException) {
                    }
                }
                if (name.equals("bundle")) {
                    try {
                        String[] content = Files.readString(p).split("--detail");
                        bundleDescription.set(content[0].trim());
                        if (content.length > 1) {
                            bundleDetail.set(content[1].trim());
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        return new BundleDescription(bundleId, bundleVersion.intValue(), autorun, minInstances, maxInstances, new ArrayList<Component>(components), payloads, (String)bundleDescription.get(), (String)bundleDetail.get());
    }

    private Component toComponent(Node node) throws Exception {
        ASTTypeDeclaration classDef = (ASTTypeDeclaration)node.getFirstDescendantOfType(ASTTypeDeclaration.class);
        Component resp = null;
        if (JavaComponentParser.isSaga(classDef)) {
            resp = new JavaSagaParser(node).parse();
        } else if (JavaComponentParser.isAggregate(classDef)) {
            resp = new JavaAggregateParser(node).parse();
        } else if (JavaComponentParser.isProjection(classDef)) {
            resp = new JavaProjectionParser(node).parse();
        } else if (JavaComponentParser.isProjector(classDef)) {
            resp = new JavaProjectorParser(node).parse();
        } else if (JavaComponentParser.isObserver(classDef)) {
            resp = new JavaObserverParser(node).parse();
        } else if (JavaComponentParser.isService(classDef)) {
            resp = new JavaServiceParser(node).parse();
        } else if (JavaComponentParser.isInvoker(classDef)) {
            resp = new JavaInvokerParser(node).parse();
        }
        if (resp != null) {
            resp.setLine(classDef.getBeginLine());
        }
        return resp;
    }

    private PayloadDescription toPayload(Node node) {
        ASTClassOrInterfaceDeclaration classDef = (ASTClassOrInterfaceDeclaration)node.getFirstDescendantOfType(ASTClassOrInterfaceDeclaration.class);
        if (classDef == null) {
            return null;
        }
        AbstractJavaNode extendedClass = (AbstractJavaNode)((JavaNode)classDef.getParent()).getFirstDescendantOfType(ASTExtendsList.class);
        if (extendedClass == null) {
            extendedClass = (AbstractJavaNode)((JavaNode)classDef.getParent()).getFirstDescendantOfType(ASTImplementsList.class);
        }
        if (extendedClass == null) {
            return null;
        }
        String payloadType = ((ASTClassOrInterfaceType)extendedClass.getFirstDescendantOfType(ASTClassOrInterfaceType.class)).getImage();
        if (payloadType.equals("DomainCommand") || payloadType.equals("DomainEvent") || payloadType.equals("ServiceCommand") || payloadType.equals("ServiceEvent") || payloadType.equals("Query") || payloadType.equals("View")) {
            JsonObject schema = new JsonObject();
            List fields = node.findDescendantsOfType(ASTFieldDeclaration.class);
            for (ASTFieldDeclaration field : fields) {
                String name = ((ASTVariableDeclaratorId)field.getFirstDescendantOfType(ASTVariableDeclaratorId.class)).getName();
                ASTClassOrInterfaceType t = (ASTClassOrInterfaceType)field.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
                String type = t != null ? t.getImage() : ((ASTPrimitiveType)field.getFirstDescendantOfType(ASTPrimitiveType.class)).getImage();
                schema.addProperty(name, type);
            }
            switch (payloadType) {
                case "DomainCommand": {
                    this.addSuperFields(schema, DomainCommand.class);
                    break;
                }
                case "DomainEvent": {
                    this.addSuperFields(schema, DomainEvent.class);
                    break;
                }
                case "ServiceCommand": {
                    this.addSuperFields(schema, ServiceCommand.class);
                    break;
                }
                case "ServiceEvent": {
                    this.addSuperFields(schema, ServiceEvent.class);
                    break;
                }
                case "Query": {
                    this.addSuperFields(schema, Query.class);
                    break;
                }
                default: {
                    this.addSuperFields(schema, View.class);
                }
            }
            String domain = null;
            try {
                domain = ((ASTLiteral)((JavaNode)classDef.getParent()).findDescendantsOfType(ASTMemberValuePair.class).stream().filter(p -> ((ASTName)((ASTAnnotation)p.getFirstParentOfType(ASTAnnotation.class)).getFirstDescendantOfType(ASTName.class)).getImage().equals("Domain")).findFirst().orElseThrow().getFirstDescendantOfType(ASTLiteral.class)).getImage().replace("\"", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new PayloadDescription(classDef.getSimpleName(), domain, payloadType, schema.toString(), classDef.getBeginLine());
        }
        return null;
    }

    private void addSuperFields(JsonObject schema, Class<?> clazz) {
        for (Field declaredField : clazz.getDeclaredFields()) {
            schema.addProperty(declaredField.getName(), declaredField.getType().getSimpleName());
        }
    }
}

