/*
 * Decompiled with CFR 0.152.
 */
package com.evento.parser.java;

import com.evento.parser.java.JavaComponentParser;
import com.evento.parser.model.component.Observer;
import com.evento.parser.model.handler.EventHandler;
import com.evento.parser.model.payload.Event;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import org.jaxen.JaxenException;

public class JavaObserverParser
extends JavaComponentParser<Observer> {
    public JavaObserverParser(Node node) {
        super(node);
    }

    private List<EventHandler> findEventHandlers() throws JaxenException {
        String query = this.getQueryForAnnotatedMethod("EventHandler");
        return ((ASTTypeDeclaration)this.node.getFirstChildOfType(ASTTypeDeclaration.class)).findChildNodesWithXPath(query).stream().map(n -> {
            ASTMethodDeclaration md = (ASTMethodDeclaration)n;
            String eventName = ((ASTClassOrInterfaceType)md.getFormalParameters().getFirstDescendantOfType(ASTClassOrInterfaceType.class)).getImage();
            return new EventHandler(new Event(eventName), n.getBeginLine());
        }).collect(Collectors.toList());
    }

    @Override
    public Observer parse() throws Exception {
        Observer observer = new Observer();
        observer.setComponentName(this.getDeclaredClassName());
        observer.setEventHandlers(this.findEventHandlers());
        this.findCommandInvocations(observer.getEventHandlers());
        this.findQueryInvocations(observer.getEventHandlers());
        return observer;
    }
}

