/*
 * Decompiled with CFR 0.152.
 */
package com.eventsourcing.postgresql;

import com.eventsourcing.Repository;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

class PooledDataSource {
    private static Map<Repository, PooledDataSource> instance = new HashMap<Repository, PooledDataSource>();
    private DataSource dataSource;
    private HikariConfig hikariConfig = new HikariConfig();

    PooledDataSource() {
    }

    public static PooledDataSource getInstance(Repository repository) {
        return instance.computeIfAbsent(repository, r -> new PooledDataSource());
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = new HikariDataSource(this.hikariConfig);
        }
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public HikariConfig getHikariConfig() {
        return this.hikariConfig;
    }

    public void setHikariConfig(HikariConfig hikariConfig) {
        this.hikariConfig = hikariConfig;
    }
}

