/*
 * Decompiled with CFR 0.152.
 */
package com.eventsourcing.postgresql;

import com.eventsourcing.Journal;
import com.eventsourcing.Repository;
import com.eventsourcing.index.CQIndexEngine;
import com.eventsourcing.index.IndexEngine;
import com.eventsourcing.postgresql.DataSourceProvider;
import com.eventsourcing.postgresql.PooledDataSource;
import com.eventsourcing.postgresql.index.EqualityIndex;
import com.eventsourcing.postgresql.index.NavigableIndex;
import com.impossibl.postgres.jdbc.PGDataSource;
import com.zaxxer.hikari.HikariConfig;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"type=PostgreSQLIndexEngine"})
public class PostgreSQLIndexEngine
extends CQIndexEngine
implements IndexEngine {
    @Reference
    protected DataSourceProvider dataSourceProvider;
    private HikariConfig hikariConfig;
    private DataSource dataSource;

    public String getType() {
        return "PostgreSQLIndexEngine";
    }

    public PostgreSQLIndexEngine() {
    }

    public PostgreSQLIndexEngine(PGDataSource dataSource) {
        this.dataSourceProvider = () -> dataSource;
    }

    public PostgreSQLIndexEngine(PGDataSource dataSource, HikariConfig hikariConfig) {
        this.dataSourceProvider = () -> dataSource;
        this.hikariConfig = hikariConfig;
    }

    public void setRepository(Repository repository) throws IllegalStateException {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this.repository = repository;
        PooledDataSource pooledDataSource = PooledDataSource.getInstance(repository);
        if (this.hikariConfig != null) {
            pooledDataSource.setHikariConfig(this.hikariConfig);
        }
        pooledDataSource.getHikariConfig().setDataSource((DataSource)this.dataSourceProvider.getDataSource());
        this.dataSource = pooledDataSource.getDataSource();
    }

    public void setJournal(Journal journal) throws IllegalStateException {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this.journal = journal;
    }

    protected void doStop() {
        super.doStop();
    }

    protected List<IndexEngine.IndexCapabilities> getIndexMatrix() {
        return Arrays.asList(new IndexEngine.IndexCapabilities("Hash", new IndexEngine.IndexFeature[]{IndexEngine.IndexFeature.EQ, IndexEngine.IndexFeature.IN, IndexEngine.IndexFeature.QZ}, attribute -> EqualityIndex.onAttribute(this.dataSource, attribute, false)), new IndexEngine.IndexCapabilities("Unique", new IndexEngine.IndexFeature[]{IndexEngine.IndexFeature.EQ, IndexEngine.IndexFeature.IN, IndexEngine.IndexFeature.QZ, IndexEngine.IndexFeature.UNIQUE}, attribute -> EqualityIndex.onAttribute(this.dataSource, attribute, true)), new IndexEngine.IndexCapabilities("Navigable", new IndexEngine.IndexFeature[]{IndexEngine.IndexFeature.EQ, IndexEngine.IndexFeature.IN, IndexEngine.IndexFeature.QZ, IndexEngine.IndexFeature.LT, IndexEngine.IndexFeature.GT, IndexEngine.IndexFeature.BT}, attr -> NavigableIndex.onAttribute(this.dataSource, attr)));
    }

    public String toString() {
        return "PostgreSQLIndexEngine[" + this.dataSource + "]";
    }
}

