/*
 * Decompiled with CFR 0.152.
 */
package com.eventsourcing.postgresql;

import com.eventsourcing.Command;
import com.eventsourcing.Entity;
import com.eventsourcing.EntityHandle;
import com.eventsourcing.Event;
import com.eventsourcing.Journal;
import com.eventsourcing.JournalEntityHandle;
import com.eventsourcing.Repository;
import com.eventsourcing.layout.Layout;
import com.eventsourcing.layout.Property;
import com.eventsourcing.layout.TypeHandler;
import com.eventsourcing.layout.binary.BinarySerialization;
import com.eventsourcing.postgresql.DataSourceProvider;
import com.eventsourcing.postgresql.PooledDataSource;
import com.eventsourcing.postgresql.PostgreSQLSerialization;
import com.eventsourcing.postgresql.PostgreSQLStatementIterator;
import com.google.common.base.Joiner;
import com.google.common.io.BaseEncoding;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.AbstractService;
import com.googlecode.cqengine.index.support.CloseableIterator;
import com.impossibl.postgres.jdbc.PGDataSource;
import com.zaxxer.hikari.HikariConfig;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"type=PostgreSQLJournal"}, service={Journal.class})
public class PostgreSQLJournal
extends AbstractService
implements Journal {
    @Reference
    protected DataSourceProvider dataSourceProvider;
    private HikariConfig hikariConfig;
    private DataSource dataSource;
    private Repository repository;
    private EntityLayoutExtractor entityLayoutExtractor = new EntityLayoutExtractor();
    private Map<String, InsertFunction> insertFunctions = new ConcurrentHashMap<String, InsertFunction>();
    private Map<String, ReaderFunction> readerFunctions = new ConcurrentHashMap<String, ReaderFunction>();
    private Map<String, Layout> layoutsByClass = new ConcurrentHashMap<String, Layout>();
    private Map<String, Layout> layoutsByHash = new ConcurrentHashMap<String, Layout>();

    public void setRepository(Repository repository) {
        this.repository = repository;
        PooledDataSource pooledDataSource = PooledDataSource.getInstance(repository);
        if (this.hikariConfig != null) {
            pooledDataSource.setHikariConfig(this.hikariConfig);
        }
        pooledDataSource.getHikariConfig().setDataSource((DataSource)this.dataSourceProvider.getDataSource());
        this.dataSource = pooledDataSource.getDataSource();
    }

    public PostgreSQLJournal() {
    }

    public PostgreSQLJournal(PGDataSource dataSource) {
        this.dataSourceProvider = () -> dataSource;
    }

    public PostgreSQLJournal(PGDataSource dataSource, HikariConfig hikariConfig) {
        this.dataSourceProvider = () -> dataSource;
        this.hikariConfig = hikariConfig;
    }

    public void onCommandsAdded(Set<Class<? extends Command>> commands) {
        commands.forEach(this.entityLayoutExtractor);
    }

    public void onEventsAdded(Set<Class<? extends Event>> events) {
        events.forEach(this.entityLayoutExtractor);
    }

    public Journal.Transaction beginTransaction() {
        return new Transaction(this.dataSource);
    }

    public <S, T> Command<S, T> journal(Journal.Transaction tx, Command<S, T> command) {
        Layout layout = this.getLayout(command.getClass());
        String encoded = BaseEncoding.base16().encode(layout.getHash());
        this.insertFunctions.get(encoded).apply((Object)command, ((Transaction)tx).getConnection());
        BinarySerialization serialization = BinarySerialization.getInstance();
        ByteBuffer s = serialization.getSerializer(command.getClass()).serialize(command);
        s.rewind();
        Command command1 = (Command)serialization.getDeserializer(command.getClass()).deserialize(s);
        command1.uuid(command.uuid());
        return command1;
    }

    public Event journal(Journal.Transaction tx, Event event) {
        Layout layout = this.getLayout(event.getClass());
        String encoded = BaseEncoding.base16().encode(layout.getHash());
        InsertFunction insert = this.insertFunctions.get(encoded);
        insert.apply((Object)event, ((Transaction)tx).getConnection());
        BinarySerialization serialization = BinarySerialization.getInstance();
        ByteBuffer s = serialization.getSerializer(event.getClass()).serialize((Object)event);
        s.rewind();
        Event event1 = (Event)serialization.getDeserializer(event.getClass()).deserialize(s);
        event1.uuid(event.uuid());
        return event1;
    }

    public <T extends Entity> Optional<T> get(UUID uuid) {
        Optional<Object> result;
        PreparedStatement s;
        Connection connection;
        block28: {
            connection = this.dataSource.getConnection();
            PostgreSQLSerialization.refreshConnectionRegistry(connection);
            s = connection.prepareStatement("SELECT layout FROM layouts_v1 WHERE uuid = ?::UUID");
            s.setString(1, uuid.toString());
            try (ResultSet resultSet = s.executeQuery();){
                if (resultSet.next()) {
                    byte[] bytes = resultSet.getBytes(1);
                    String hash = BaseEncoding.base16().encode(bytes);
                    ReaderFunction reader = this.readerFunctions.get(hash);
                    Layout layout = this.getLayout(bytes);
                    String columns = Joiner.on((String)", ").join((Iterable)layout.getProperties().stream().map(p -> "\"" + p.getName() + "\"").collect(Collectors.toList()));
                    String query = "SELECT " + columns + " FROM layout_v1_" + hash + " WHERE uuid = ?::UUID";
                    PreparedStatement s1 = connection.prepareStatement(query);
                    s1.setString(1, uuid.toString());
                    try (ResultSet rs = s1.executeQuery();){
                        rs.next();
                        Entity o = (Entity)reader.apply(rs);
                        o.uuid(uuid);
                        result = Optional.of(o);
                    }
                    s1.close();
                    break block28;
                }
                result = Optional.empty();
            }
        }
        s.close();
        connection.close();
        return result;
    }

    public <T extends Command<?, ?>> CloseableIterator<EntityHandle<T>> commandIterator(Class<T> klass) {
        return this.entityIterator(klass);
    }

    public <T extends Event> CloseableIterator<EntityHandle<T>> eventIterator(Class<T> klass) {
        return this.entityIterator(klass);
    }

    private <T extends Entity> CloseableIterator<EntityHandle<T>> entityIterator(Class<T> klass) {
        Connection connection = this.dataSource.getConnection();
        Layout layout = this.getLayout(klass);
        String hash = BaseEncoding.base16().encode(layout.getHash());
        PreparedStatement s = connection.prepareStatement("SELECT uuid FROM layout_v1_" + hash);
        return new EntityIterator(this, s, connection);
    }

    public void clear() {
        final Connection connection = this.dataSource.getConnection();
        this.layoutsByHash.keySet().forEach(new Consumer<String>(){

            @Override
            public void accept(String hash) {
                PreparedStatement s = connection.prepareStatement("DELETE FROM layout_v1_" + hash);
                s.execute();
                s.close();
            }
        });
        PreparedStatement check = connection.prepareStatement("SELECT * from pg_catalog.pg_tables WHERE tablename = 'layouts' AND schemaname = ?");
        check.setString(1, "eventsourcing");
        try (ResultSet resultSet = check.executeQuery();){
            if (resultSet.next()) {
                PreparedStatement s = connection.prepareStatement("DELETE FROM layouts_v1");
                s.execute();
                s.close();
            }
        }
        check.close();
        connection.close();
    }

    public <T extends Entity> long size(Class<T> klass) {
        long size;
        Layout layout = this.getLayout(klass);
        String hash = BaseEncoding.base16().encode(layout.getHash());
        Connection connection = this.dataSource.getConnection();
        PreparedStatement s = connection.prepareStatement("SELECT count(uuid) FROM layout_v1_" + hash);
        try (ResultSet resultSet = s.executeQuery();){
            resultSet.next();
            size = resultSet.getLong(1);
        }
        s.close();
        connection.close();
        return size;
    }

    public <T extends Entity> boolean isEmpty(Class<T> klass) {
        return this.size(klass) == 0L;
    }

    protected void doStart() {
        if (this.repository == null) {
            this.notifyFailed(new IllegalStateException("repository == null"));
        }
        if (this.dataSource == null) {
            this.notifyFailed(new IllegalStateException("dataSource == null"));
        }
        this.ensureLatestSchemaVersion();
        this.notifyStarted();
    }

    private void ensureLatestSchemaVersion() {
        try (Connection connection = this.dataSource.getConnection();){
            try (PreparedStatement s = connection.prepareStatement("CREATE TABLE IF NOT EXISTS layouts_v1 (\n  uuid   UUID PRIMARY KEY,\n  layout BYTEA NOT NULL\n)");){
                s.executeUpdate();
            }
            String timestampFunction = CharStreams.toString((Readable)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("timestamp_function.sql")));
            try (PreparedStatement s = connection.prepareStatement(timestampFunction);){
                s.executeUpdate();
            }
        }
    }

    protected void doStop() {
        this.notifyStopped();
    }

    private Layout getLayout(Class<? extends Entity> klass) {
        if (!this.layoutsByClass.containsKey(klass.getName())) {
            this.entityLayoutExtractor.accept(klass);
        }
        return this.layoutsByClass.get(klass.getName());
    }

    private Layout getLayout(byte[] hash) {
        String encoded = BaseEncoding.base16().encode(hash);
        return this.layoutsByHash.get(encoded);
    }

    protected static String defineColumns(Connection connection, Layout<?> layout) {
        return Joiner.on((String)",\n").join((Iterable)layout.getProperties().stream().map(p -> "\"" + p.getName() + "\" " + PostgreSQLSerialization.getMappedType(connection, p.getTypeHandler())).collect(Collectors.toList()));
    }

    public Repository getRepository() {
        return this.repository;
    }

    private class EntityLayoutExtractor
    implements Consumer<Class<? extends Entity>> {
        private EntityLayoutExtractor() {
        }

        @Override
        public void accept(Class<? extends Entity> aClass) {
            Layout layout = Layout.forClass(aClass);
            PostgreSQLJournal.this.layoutsByClass.put(aClass.getName(), layout);
            byte[] fingerprint = layout.getHash();
            String encoded = BaseEncoding.base16().encode(fingerprint);
            PostgreSQLJournal.this.layoutsByHash.put(encoded, layout);
            Connection connection = PostgreSQLJournal.this.dataSource.getConnection();
            String columns = PostgreSQLJournal.defineColumns(connection, layout);
            String createTable = "CREATE TABLE IF NOT EXISTS layout_v1_" + encoded + " (uuid UUID PRIMARY KEY," + columns + ")";
            PreparedStatement s = connection.prepareStatement(createTable);
            s.execute();
            s.close();
            s = connection.prepareStatement("COMMENT ON TABLE layout_v1_" + encoded + " IS '" + layout.getName() + "'");
            s.execute();
            s.close();
            connection.close();
            InsertFunction insertFunction = new InsertFunction(layout);
            PostgreSQLJournal.this.insertFunctions.put(encoded, insertFunction);
            ReaderFunction readerFunction = new ReaderFunction(layout);
            PostgreSQLJournal.this.readerFunctions.put(encoded, readerFunction);
        }
    }

    private class InsertFunction
    implements BiFunction<Object, Connection, UUID> {
        private final Layout<?> layout;
        private final String table;
        private final List<? extends Property> properties;

        public InsertFunction(Layout<?> layout) {
            this.layout = layout;
            this.table = "layout_v1_" + BaseEncoding.base16().encode(layout.getHash());
            this.properties = layout.getProperties();
        }

        @Override
        public UUID apply(Object object, Connection connection) {
            String parameters = Joiner.on((String)",").join((Iterable)this.properties.stream().map(p -> PostgreSQLSerialization.getParameter(connection, p.getTypeHandler(), p.get(object))).collect(Collectors.toList()));
            PreparedStatement s = connection.prepareStatement("INSERT INTO " + this.table + " VALUES (?::UUID," + parameters + ")");
            int i = 1;
            UUID uuid = object instanceof Entity ? ((Entity)object).uuid() : UUID.randomUUID();
            s.setString(i, uuid.toString());
            ++i;
            for (Property property : this.layout.getProperties()) {
                Object value = property.get(object);
                i = PostgreSQLSerialization.setValue(connection, s, i, value, property.getTypeHandler());
            }
            s.execute();
            PreparedStatement layoutsInsertion = connection.prepareStatement("INSERT INTO layouts_v1 VALUES (?::UUID, ?)");
            layoutsInsertion.setString(1, uuid.toString());
            layoutsInsertion.setBytes(2, this.layout.getHash());
            layoutsInsertion.executeUpdate();
            s.close();
            return uuid;
        }
    }

    private class ReaderFunction
    implements Function<ResultSet, Object> {
        private final Layout layout;

        public ReaderFunction(Layout<?> layout) {
            this.layout = layout;
        }

        @Override
        public Object apply(ResultSet resultSet) {
            AtomicInteger i = new AtomicInteger(1);
            List properties = this.layout.getProperties();
            HashMap<Property, Object> props = new HashMap<Property, Object>();
            for (Property property : properties) {
                TypeHandler typeHandler = property.getTypeHandler();
                props.put(property, PostgreSQLSerialization.getValue(resultSet, i, typeHandler));
            }
            return this.layout.instantiate(props);
        }
    }

    private static class EntityIterator<R extends Entity>
    extends PostgreSQLStatementIterator<EntityHandle<R>> {
        private final Journal journal;

        public EntityIterator(Journal journal, PreparedStatement statement, Connection connection) {
            super(statement, connection, true);
            this.journal = journal;
        }

        @Override
        public EntityHandle<R> fetchNext() {
            return new JournalEntityHandle(this.journal, UUID.fromString(this.resultSet.getString(1)));
        }
    }

    static final class Transaction
    implements Journal.Transaction {
        private final Connection connection;
        private final Savepoint savepoint;

        public Transaction(DataSource dataSource) {
            this.connection = dataSource.getConnection();
            this.connection.setAutoCommit(false);
            this.savepoint = this.connection.setSavepoint();
        }

        public void commit() {
            this.connection.releaseSavepoint(this.savepoint);
            this.connection.commit();
            this.connection.close();
        }

        public void rollback() {
            this.connection.rollback(this.savepoint);
            this.connection.releaseSavepoint(this.savepoint);
            this.connection.close();
        }

        public Connection getConnection() {
            return this.connection;
        }

        public Savepoint getSavepoint() {
            return this.savepoint;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Transaction)) {
                return false;
            }
            Transaction other = (Transaction)o;
            Connection this$connection = this.getConnection();
            Connection other$connection = other.getConnection();
            if (this$connection == null ? other$connection != null : !this$connection.equals(other$connection)) {
                return false;
            }
            Savepoint this$savepoint = this.getSavepoint();
            Savepoint other$savepoint = other.getSavepoint();
            return !(this$savepoint == null ? other$savepoint != null : !this$savepoint.equals(other$savepoint));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Connection $connection = this.getConnection();
            result = result * 59 + ($connection == null ? 43 : $connection.hashCode());
            Savepoint $savepoint = this.getSavepoint();
            result = result * 59 + ($savepoint == null ? 43 : $savepoint.hashCode());
            return result;
        }

        public String toString() {
            return "PostgreSQLJournal.Transaction(connection=" + this.getConnection() + ", savepoint=" + this.getSavepoint() + ")";
        }
    }
}

