/*
 * Decompiled with CFR 0.152.
 */
package com.eventsourcing.postgresql;

import com.eventsourcing.Lock;
import com.eventsourcing.LockProvider;
import com.eventsourcing.postgresql.DataSourceProvider;
import com.google.common.util.concurrent.AbstractService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"type=PostgreSQLLockProvider"})
public class PostgreSQLLockProvider
extends AbstractService
implements LockProvider {
    @Reference
    protected DataSourceProvider dataSourceProvider;
    private DataSource dataSource;

    @Activate
    protected void activate() {
        this.dataSource = this.dataSourceProvider.getDataSource();
    }

    public PostgreSQLLockProvider() {
    }

    protected void doStart() {
        this.notifyStarted();
    }

    protected void doStop() {
        this.notifyStopped();
    }

    public PostgreSQLLockProvider(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Lock lock(Object lock) {
        return new PostgreSQLLock(this.dataSource.getConnection(), lock.hashCode());
    }

    public class PostgreSQLLock
    implements Lock {
        private final Connection connection;
        private final long key;
        private boolean locked;

        public PostgreSQLLock(Connection connection, long key) throws SQLException {
            this.connection = connection;
            this.key = key;
            this.locked = true;
            try (PreparedStatement s = connection.prepareStatement("SELECT pg_advisory_lock(?)");){
                s.setLong(1, key);
                s.execute();
            }
        }

        public void unlock() {
            try (PreparedStatement s = this.connection.prepareStatement("SELECT pg_advisory_unlock(?)");){
                s.setLong(1, this.key);
                s.execute();
            }
            this.connection.close();
            this.locked = false;
        }

        public boolean isLocked() {
            return this.locked;
        }
    }
}

