/*
 * Decompiled with CFR 0.152.
 */
package com.eventsourcing.postgresql;

import com.eventsourcing.layout.Layout;
import com.eventsourcing.layout.Property;
import com.eventsourcing.layout.TypeHandler;
import com.eventsourcing.layout.types.BigDecimalTypeHandler;
import com.eventsourcing.layout.types.BooleanTypeHandler;
import com.eventsourcing.layout.types.ByteArrayTypeHandler;
import com.eventsourcing.layout.types.ByteTypeHandler;
import com.eventsourcing.layout.types.DateTypeHandler;
import com.eventsourcing.layout.types.DoubleTypeHandler;
import com.eventsourcing.layout.types.EnumTypeHandler;
import com.eventsourcing.layout.types.FloatTypeHandler;
import com.eventsourcing.layout.types.IntegerTypeHandler;
import com.eventsourcing.layout.types.ListTypeHandler;
import com.eventsourcing.layout.types.LongTypeHandler;
import com.eventsourcing.layout.types.MapTypeHandler;
import com.eventsourcing.layout.types.ObjectTypeHandler;
import com.eventsourcing.layout.types.OptionalTypeHandler;
import com.eventsourcing.layout.types.ShortTypeHandler;
import com.eventsourcing.layout.types.StringTypeHandler;
import com.eventsourcing.layout.types.UUIDTypeHandler;
import com.eventsourcing.postgresql.PostgreSQLJournal;
import com.google.common.io.BaseEncoding;
import com.impossibl.postgres.api.jdbc.PGConnection;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.PGStruct;
import com.impossibl.postgres.system.Version;
import com.impossibl.postgres.system.tables.PgAttribute;
import com.impossibl.postgres.system.tables.PgProc;
import com.impossibl.postgres.system.tables.PgType;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Timestamp;
import java.sql.Wrapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PostgreSQLSerialization {
    private static List<PgType.Row> pgTypes = new ArrayList<PgType.Row>();
    private static List<PgAttribute.Row> pgAttrs = new ArrayList<PgAttribute.Row>();
    private static List<PgProc.Row> pgProcs = new ArrayList<PgProc.Row>();

    public static void refreshTypes(Connection connection) {
        PGConnection conn = PostgreSQLSerialization.getPgConnection(connection);
        PGConnectionImpl connImpl = (PGConnectionImpl)conn;
        Version serverVersion = connImpl.getServerVersion();
        String typeSQL = PgType.INSTANCE.getSQL(serverVersion);
        pgTypes = connImpl.queryResults(typeSQL, PgType.Row.class, new Object[0]);
        String attrsSQL = PgAttribute.INSTANCE.getSQL(serverVersion);
        pgAttrs = connImpl.queryResults(attrsSQL, PgAttribute.Row.class, new Object[0]);
        String procsSQL = PgProc.INSTANCE.getSQL(serverVersion);
        pgProcs = connImpl.queryResults(procsSQL, PgProc.Row.class, new Object[0]);
    }

    protected static PGConnection getPgConnection(Connection connection) {
        PGConnection conn;
        if (connection instanceof Wrapper) {
            try {
                conn = connection.unwrap(PGConnection.class);
            }
            catch (SQLException e) {
                throw new RuntimeException("pgjdbc-ng is required");
            }
        } else if (connection instanceof PGConnection) {
            conn = (PGConnection)connection;
        } else {
            throw new RuntimeException("pgjdbc-ng is required");
        }
        return conn;
    }

    public static void refreshConnectionRegistry(Connection connection) {
        PGConnection conn = PostgreSQLSerialization.getPgConnection(connection);
        PGConnectionImpl connImpl = (PGConnectionImpl)conn;
        connImpl.getRegistry().update(pgTypes, pgAttrs, pgProcs);
    }

    public static String getMappedType(Connection connection, TypeHandler typeHandler) {
        if (typeHandler instanceof BigDecimalTypeHandler) {
            return "NUMERIC";
        }
        if (typeHandler instanceof BooleanTypeHandler) {
            return "BOOLEAN";
        }
        if (typeHandler instanceof ByteArrayTypeHandler) {
            return "BYTEA";
        }
        if (typeHandler instanceof ByteTypeHandler) {
            return "SMALLINT";
        }
        if (typeHandler instanceof DateTypeHandler) {
            return "TIMESTAMP";
        }
        if (typeHandler instanceof DoubleTypeHandler) {
            return "DOUBLE PRECISION";
        }
        if (typeHandler instanceof EnumTypeHandler) {
            return "INTEGER";
        }
        if (typeHandler instanceof FloatTypeHandler) {
            return "REAL";
        }
        if (typeHandler instanceof IntegerTypeHandler) {
            return "INTEGER";
        }
        if (typeHandler instanceof ListTypeHandler) {
            TypeHandler wrappedHandler = ((ListTypeHandler)typeHandler).getWrappedHandler();
            String mappedType = PostgreSQLSerialization.getMappedType(connection, wrappedHandler);
            if (wrappedHandler instanceof ListTypeHandler) {
                boolean shouldCreateType;
                mappedType = mappedType.replaceAll("\\[\\]$", "");
                String typname = "layout_v1_arr_" + mappedType;
                PreparedStatement check = connection.prepareStatement("SELECT * FROM pg_catalog.pg_type WHERE lower(typname) = lower(?)");
                check.setString(1, typname);
                try (ResultSet resultSet = check.executeQuery();){
                    shouldCreateType = !resultSet.next();
                }
                check.close();
                if (shouldCreateType) {
                    String createType = "CREATE TYPE " + typname + " AS (\"value\" " + mappedType + "[])";
                    PreparedStatement s = connection.prepareStatement(createType);
                    s.execute();
                    s.close();
                    s = connection.prepareStatement("COMMENT ON TYPE " + typname + " IS '" + mappedType + " array'");
                    s.execute();
                    s.close();
                    PostgreSQLSerialization.refreshTypes(connection);
                }
                return typname + "[]";
            }
            return mappedType + "[]";
        }
        if (typeHandler instanceof LongTypeHandler) {
            return "BIGINT";
        }
        if (typeHandler instanceof ObjectTypeHandler) {
            boolean shouldCreateType;
            Layout layout = ((ObjectTypeHandler)typeHandler).getLayout();
            byte[] fingerprint = layout.getHash();
            String encoded = BaseEncoding.base16().encode(fingerprint);
            String typname = "layout_v1_" + encoded;
            PreparedStatement check = connection.prepareStatement("SELECT * FROM pg_catalog.pg_type WHERE lower(typname) = lower(?)");
            check.setString(1, typname);
            try (ResultSet resultSet = check.executeQuery();){
                shouldCreateType = !resultSet.next();
            }
            check.close();
            if (shouldCreateType) {
                String columns = PostgreSQLJournal.defineColumns(connection, layout);
                String createType = "CREATE TYPE " + typname + " AS (" + columns + ")";
                PreparedStatement s = connection.prepareStatement(createType);
                s.execute();
                s.close();
                s = connection.prepareStatement("COMMENT ON TYPE " + typname + " IS '" + layout.getName() + "'");
                s.execute();
                s.close();
                PostgreSQLSerialization.refreshTypes(connection);
            }
            return typname.toLowerCase();
        }
        if (typeHandler instanceof OptionalTypeHandler) {
            return PostgreSQLSerialization.getMappedType(connection, ((OptionalTypeHandler)typeHandler).getWrappedHandler());
        }
        if (typeHandler instanceof ShortTypeHandler) {
            return "SMALLINT";
        }
        if (typeHandler instanceof StringTypeHandler) {
            return "TEXT";
        }
        if (typeHandler instanceof UUIDTypeHandler) {
            return "UUID";
        }
        if (typeHandler instanceof MapTypeHandler) {
            boolean shouldCreateType;
            Object resultSet;
            String typname;
            String valueType;
            String keyType;
            block109: {
                keyType = PostgreSQLSerialization.getMappedType(connection, ((MapTypeHandler)typeHandler).getWrappedKeyHandler());
                valueType = PostgreSQLSerialization.getMappedType(connection, ((MapTypeHandler)typeHandler).getWrappedValueHandler());
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                digest.update(keyType.getBytes());
                digest.update(valueType.getBytes());
                String encodedHash = BaseEncoding.base16().encode(digest.digest());
                typname = "map_v2_" + encodedHash;
                String v1typname = ("map_v1_" + keyType + "_" + valueType).replaceAll("\\[\\]", "__");
                try (PreparedStatement check = connection.prepareStatement("SELECT lower(typname) FROM pg_catalog.pg_type WHERE lower(typname) = lower(?)::name");){
                    check.setString(1, v1typname);
                    resultSet = check.executeQuery();
                    Throwable throwable = null;
                    try {
                        if (!resultSet.next()) break block109;
                        try (PreparedStatement s = connection.prepareStatement("ALTER TABLE " + resultSet.getString(1) + " RENAME TO " + typname);){
                            s.executeUpdate();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (resultSet != null) {
                            if (throwable != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                resultSet.close();
                            }
                        }
                    }
                }
            }
            PreparedStatement check = connection.prepareStatement("SELECT * FROM pg_catalog.pg_type WHERE lower(typname) = lower(?)");
            resultSet = null;
            try {
                check.setString(1, typname);
                try (ResultSet resultSet2 = check.executeQuery();){
                    shouldCreateType = !resultSet2.next();
                }
            }
            catch (Throwable resultSet2) {
                resultSet = resultSet2;
                throw resultSet2;
            }
            finally {
                if (check != null) {
                    if (resultSet != null) {
                        try {
                            check.close();
                        }
                        catch (Throwable resultSet2) {
                            ((Throwable)resultSet).addSuppressed(resultSet2);
                        }
                    } else {
                        check.close();
                    }
                }
            }
            if (shouldCreateType) {
                String columns = "key " + keyType + ", value " + valueType;
                String createType = "CREATE TYPE " + typname + " AS (" + columns + ")";
                PreparedStatement s = connection.prepareStatement(createType);
                s.execute();
                s.close();
                s = connection.prepareStatement("COMMENT ON TYPE " + typname + " IS 'Map[" + keyType + "][" + valueType + "]'");
                s.execute();
                s.close();
                PostgreSQLSerialization.refreshTypes(connection);
            }
            return typname.toLowerCase() + "[]";
        }
        throw new RuntimeException("Unsupported type handler " + typeHandler.getClass());
    }

    public static int getMappedSqlType(TypeHandler typeHandler) {
        if (typeHandler instanceof BigDecimalTypeHandler) {
            return 3;
        }
        if (typeHandler instanceof BooleanTypeHandler) {
            return 16;
        }
        if (typeHandler instanceof ByteArrayTypeHandler) {
            return -2;
        }
        if (typeHandler instanceof ByteTypeHandler) {
            return 5;
        }
        if (typeHandler instanceof DateTypeHandler) {
            return 93;
        }
        if (typeHandler instanceof DoubleTypeHandler) {
            return 8;
        }
        if (typeHandler instanceof EnumTypeHandler) {
            return 4;
        }
        if (typeHandler instanceof FloatTypeHandler) {
            return 6;
        }
        if (typeHandler instanceof IntegerTypeHandler) {
            return 4;
        }
        if (typeHandler instanceof ListTypeHandler) {
            return 2003;
        }
        if (typeHandler instanceof MapTypeHandler) {
            return 2003;
        }
        if (typeHandler instanceof LongTypeHandler) {
            return -5;
        }
        if (typeHandler instanceof ObjectTypeHandler) {
            return 12;
        }
        if (typeHandler instanceof OptionalTypeHandler) {
            return PostgreSQLSerialization.getMappedSqlType(((OptionalTypeHandler)typeHandler).getWrappedHandler());
        }
        if (typeHandler instanceof ShortTypeHandler) {
            return 5;
        }
        if (typeHandler instanceof StringTypeHandler) {
            return 12;
        }
        if (typeHandler instanceof UUIDTypeHandler) {
            return 12;
        }
        throw new RuntimeException("Unsupported type handler " + typeHandler.getClass());
    }

    private static Object prepareValue(final Connection connection, final TypeHandler typeHandler, Object value) {
        if (typeHandler instanceof BigDecimalTypeHandler) {
            return value == null ? BigDecimal.ZERO : (BigDecimal)((Object)value);
        }
        if (typeHandler instanceof BooleanTypeHandler) {
            return value == null ? false : (Boolean)((Object)value);
        }
        if (typeHandler instanceof ByteArrayTypeHandler) {
            if (((ByteArrayTypeHandler)typeHandler).isPrimitive()) {
                return value == null ? new byte[]{} : (byte[])value;
            }
            return value == null ? new byte[]{} : (byte[])((ByteArrayTypeHandler)typeHandler).toPrimitive((Object)value);
        }
        if (typeHandler instanceof ByteTypeHandler) {
            return value == null ? (byte)0 : (Byte)((Object)value);
        }
        if (typeHandler instanceof DateTypeHandler) {
            return value == null ? Timestamp.from(Instant.EPOCH) : Timestamp.from(((Date)((Object)value)).toInstant());
        }
        if (typeHandler instanceof DoubleTypeHandler) {
            return value == null ? 0.0 : (Double)((Object)value);
        }
        if (typeHandler instanceof EnumTypeHandler) {
            return value == null ? 0 : ((Enum)((Object)value)).ordinal();
        }
        if (typeHandler instanceof FloatTypeHandler) {
            return Float.valueOf(value == null ? 0.0f : ((Float)((Object)value)).floatValue());
        }
        if (typeHandler instanceof IntegerTypeHandler) {
            return value == null ? 0 : (Integer)((Object)value);
        }
        if (typeHandler instanceof ListTypeHandler) {
            final TypeHandler handler = ((ListTypeHandler)typeHandler).getWrappedHandler();
            List val = value == null ? Collections.emptyList() : (List)((Object)value);
            String typeName = PostgreSQLSerialization.getMappedType(connection, handler).toLowerCase();
            if (handler instanceof ListTypeHandler) {
                final String arrTypeName = PostgreSQLSerialization.getMappedType(connection, typeHandler).toLowerCase().replaceAll("\\[\\]$", "");
                Object[] arr = val.stream().map(new Function(){

                    public Object apply(Object v) {
                        return connection.createStruct(arrTypeName, new Object[]{PostgreSQLSerialization.prepareValue(connection, handler, v)});
                    }
                }).toArray();
                return connection.createArrayOf(arrTypeName, arr);
            }
            Object[] arr = val.stream().map(v -> PostgreSQLSerialization.prepareValue(connection, handler, v)).toArray();
            return connection.createArrayOf(typeName, arr);
        }
        if (typeHandler instanceof MapTypeHandler) {
            if (value == null) {
                value = new HashMap();
            }
            final String typeName = PostgreSQLSerialization.getMappedType(connection, typeHandler).replaceAll("\\[\\]", "");
            Object[] arr = ((Map)value).entrySet().stream().map(new Function(){

                public Object apply(Object e) {
                    Map.Entry entry = (Map.Entry)e;
                    return connection.createStruct(typeName, new Object[]{PostgreSQLSerialization.prepareValue(connection, ((MapTypeHandler)typeHandler).getWrappedKeyHandler(), entry.getKey()), PostgreSQLSerialization.prepareValue(connection, ((MapTypeHandler)typeHandler).getWrappedValueHandler(), entry.getValue())});
                }
            }).toArray();
            return connection.createArrayOf(typeName, arr);
        }
        if (typeHandler instanceof LongTypeHandler) {
            return value == null ? 0L : (Long)((Object)value);
        }
        if (typeHandler instanceof ObjectTypeHandler) {
            Layout objectLayout = ((ObjectTypeHandler)typeHandler).getLayout();
            Object val = value == null ? objectLayout.instantiate() : value;
            String typeName = "layout_v1_" + BaseEncoding.base16().encode(objectLayout.getHash()).toLowerCase();
            Object[] objects = objectLayout.getProperties().stream().map(p -> PostgreSQLSerialization.prepareValue(connection, p.getTypeHandler(), p.get(val))).toArray();
            return connection.createStruct(typeName, objects);
        }
        if (typeHandler instanceof OptionalTypeHandler) {
            if (value != null && ((Optional)((Object)value)).isPresent()) {
                return ((Optional)((Object)value)).get();
            }
            return null;
        }
        if (typeHandler instanceof ShortTypeHandler) {
            return value == null ? (short)0 : (Short)((Object)value);
        }
        if (typeHandler instanceof StringTypeHandler) {
            return value == null ? "" : (String)((Object)value);
        }
        if (typeHandler instanceof UUIDTypeHandler) {
            return value == null ? new UUID(0L, 0L).toString() : ((Object)value).toString();
        }
        throw new RuntimeException("Unsupported type handler " + typeHandler.getClass());
    }

    public static int setValue(Connection connection, PreparedStatement s, int i, Object value, TypeHandler typeHandler) {
        if (typeHandler instanceof BigDecimalTypeHandler) {
            s.setBigDecimal(i, (BigDecimal)PostgreSQLSerialization.prepareValue(connection, typeHandler, value));
        } else if (typeHandler instanceof BooleanTypeHandler) {
            s.setBoolean(i, (Boolean)PostgreSQLSerialization.prepareValue(connection, typeHandler, value));
        } else if (typeHandler instanceof ByteArrayTypeHandler) {
            s.setBytes(i, (byte[])PostgreSQLSerialization.prepareValue(connection, typeHandler, value));
        } else if (typeHandler instanceof ByteTypeHandler) {
            s.setByte(i, (Byte)PostgreSQLSerialization.prepareValue(connection, typeHandler, value));
        } else if (typeHandler instanceof DateTypeHandler) {
            s.setTimestamp(i, (Timestamp)PostgreSQLSerialization.prepareValue(connection, typeHandler, value));
        } else if (typeHandler instanceof DoubleTypeHandler) {
            s.setDouble(i, (Double)PostgreSQLSerialization.prepareValue(connection, typeHandler, value));
        } else if (typeHandler instanceof EnumTypeHandler) {
            s.setInt(i, (Integer)PostgreSQLSerialization.prepareValue(connection, typeHandler, value));
        } else if (typeHandler instanceof FloatTypeHandler) {
            s.setFloat(i, ((Float)PostgreSQLSerialization.prepareValue(connection, typeHandler, value)).floatValue());
        } else if (typeHandler instanceof IntegerTypeHandler) {
            s.setInt(i, (Integer)PostgreSQLSerialization.prepareValue(connection, typeHandler, value));
        } else if (typeHandler instanceof ListTypeHandler) {
            s.setObject(i, ((Array)PostgreSQLSerialization.prepareValue(connection, typeHandler, value)).getArray());
        } else if (typeHandler instanceof MapTypeHandler) {
            s.setObject(i, ((Array)PostgreSQLSerialization.prepareValue(connection, typeHandler, value)).getArray());
        } else if (typeHandler instanceof LongTypeHandler) {
            s.setLong(i, (Long)PostgreSQLSerialization.prepareValue(connection, typeHandler, value));
        } else if (typeHandler instanceof ObjectTypeHandler) {
            s.setObject(i, PostgreSQLSerialization.prepareValue(connection, typeHandler, value));
        } else {
            if (typeHandler instanceof OptionalTypeHandler) {
                TypeHandler handler = ((OptionalTypeHandler)typeHandler).getWrappedHandler();
                if (value != null && ((Optional)value).isPresent()) {
                    i = PostgreSQLSerialization.setValue(connection, s, i, ((Optional)value).get(), handler);
                } else {
                    s.setNull(i, PostgreSQLSerialization.getMappedSqlType(handler));
                    ++i;
                }
                return i;
            }
            if (typeHandler instanceof ShortTypeHandler) {
                s.setShort(i, (Short)PostgreSQLSerialization.prepareValue(connection, typeHandler, value));
            } else if (typeHandler instanceof StringTypeHandler) {
                s.setString(i, (String)PostgreSQLSerialization.prepareValue(connection, typeHandler, value));
            } else if (typeHandler instanceof UUIDTypeHandler) {
                s.setString(i, (String)PostgreSQLSerialization.prepareValue(connection, typeHandler, value));
            } else {
                throw new RuntimeException("Unsupported type handler " + typeHandler.getClass());
            }
        }
        return i + 1;
    }

    private static Object instantiateObject(Layout<?> layout, PGStruct struct) {
        Iterator<Object> structIterator = Arrays.asList(struct.getAttributes()).iterator();
        HashMap<Property, Object> props = new HashMap<Property, Object>();
        for (Property property : layout.getProperties()) {
            Object v = structIterator.next();
            props.put(property, PostgreSQLSerialization.getPropertyValue(property.getTypeHandler(), v));
        }
        Object o = layout.instantiate(props);
        return o;
    }

    private static Object getPropertyValue(TypeHandler t, Object v) {
        if (t instanceof OptionalTypeHandler) {
            return v == null ? Optional.empty() : Optional.of(v);
        }
        if (t instanceof EnumTypeHandler) {
            EnumTypeHandler typeHandler = (EnumTypeHandler)t;
            Class enumClass = typeHandler.getEnumClass();
            String[] enumNames = (String[])Arrays.stream(enumClass.getEnumConstants()).map(Enum::name).toArray(String[]::new);
            return Enum.valueOf(enumClass, enumNames[(Integer)v]);
        }
        if (v instanceof Short && t instanceof ByteTypeHandler) {
            return ((Short)v).byteValue();
        }
        if (v instanceof Timestamp) {
            return new Date(((Timestamp)v).getTime());
        }
        if (v instanceof ByteBufInputStream && t instanceof ByteArrayTypeHandler) {
            int available = ((ByteBufInputStream)v).available();
            byte[] b = new byte[available];
            ((DataInput)v).readFully(b);
            ByteArrayTypeHandler typeHandler = (ByteArrayTypeHandler)t;
            boolean isPrimitive = typeHandler.isPrimitive();
            return isPrimitive ? b : (byte[])typeHandler.toObject((Object)b);
        }
        if (v instanceof PGStruct) {
            if (t instanceof ObjectTypeHandler) {
                return PostgreSQLSerialization.instantiateObject(((ObjectTypeHandler)t).getLayout(), (PGStruct)v);
            }
            if (t instanceof ListTypeHandler) {
                return PostgreSQLSerialization.getPropertyValue(t, ((PGStruct)v).getAttributes()[0]);
            }
        } else {
            if (t instanceof ListTypeHandler && v.getClass().isArray()) {
                ListTypeHandler typeHandler = (ListTypeHandler)t;
                TypeHandler wrappedHandler = typeHandler.getWrappedHandler();
                if (wrappedHandler instanceof ObjectTypeHandler && Struct.class.isAssignableFrom(v.getClass().getComponentType())) {
                    Struct[] val = (Struct[])v;
                    ArrayList<Object> objects = new ArrayList<Object>();
                    for (Struct value : val) {
                        objects.add(PostgreSQLSerialization.instantiateObject(((ObjectTypeHandler)wrappedHandler).getLayout(), (PGStruct)value));
                    }
                    return objects;
                }
                return Arrays.stream((Object[])v).map(i -> PostgreSQLSerialization.getPropertyValue(t, i)).collect(Collectors.toList());
            }
            if (t instanceof MapTypeHandler && v.getClass().isArray()) {
                MapTypeHandler typeHandler = (MapTypeHandler)t;
                final TypeHandler keyHandler = typeHandler.getWrappedKeyHandler();
                final TypeHandler valueHandler = typeHandler.getWrappedValueHandler();
                Object[] arr = (Object[])v;
                return Arrays.stream(arr).collect(Collectors.toMap(new Function<Object, Object>(){

                    @Override
                    public Object apply(Object i) {
                        return PostgreSQLSerialization.getPropertyValue(keyHandler, ((PGStruct)i).getAttributes()[0]);
                    }
                }, new Function<Object, Object>(){

                    @Override
                    public Object apply(Object i) {
                        return PostgreSQLSerialization.getPropertyValue(valueHandler, ((PGStruct)i).getAttributes()[1]);
                    }
                }));
            }
            return v;
        }
        throw new RuntimeException("unexpected error");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getValue(ResultSet resultSet, AtomicInteger i, TypeHandler typeHandler) {
        if (typeHandler instanceof BigDecimalTypeHandler) {
            return resultSet.getBigDecimal(i.getAndIncrement());
        }
        if (typeHandler instanceof BooleanTypeHandler) {
            return resultSet.getBoolean(i.getAndIncrement());
        }
        if (typeHandler instanceof ByteArrayTypeHandler) {
            byte[] bytes = resultSet.getBytes(i.getAndIncrement());
            if (!((ByteArrayTypeHandler)typeHandler).isPrimitive()) return ((ByteArrayTypeHandler)typeHandler).toObject((Object)bytes);
            return bytes;
        }
        if (typeHandler instanceof ByteTypeHandler) {
            return resultSet.getByte(i.getAndIncrement());
        }
        if (typeHandler instanceof DateTypeHandler) {
            return Date.from(resultSet.getTimestamp(i.getAndIncrement()).toInstant());
        }
        if (typeHandler instanceof DoubleTypeHandler) {
            return resultSet.getDouble(i.getAndIncrement());
        }
        if (typeHandler instanceof EnumTypeHandler) {
            Class enumClass = ((EnumTypeHandler)typeHandler).getEnumClass();
            String[] enumNames = (String[])Arrays.stream(enumClass.getEnumConstants()).map(Enum::name).toArray(String[]::new);
            return Enum.valueOf(enumClass, enumNames[resultSet.getInt(i.getAndIncrement())]);
        }
        if (typeHandler instanceof FloatTypeHandler) {
            return Float.valueOf(resultSet.getFloat(i.getAndIncrement()));
        }
        if (typeHandler instanceof IntegerTypeHandler) {
            return resultSet.getInt(i.getAndIncrement());
        }
        if (typeHandler instanceof ListTypeHandler) {
            Array array = resultSet.getArray(i.getAndIncrement());
            try (ResultSet arrayResultSet = array.getResultSet();){
                ArrayList<Object> list = new ArrayList<Object>();
                TypeHandler handler = ((ListTypeHandler)typeHandler).getWrappedHandler();
                while (arrayResultSet.next()) {
                    Object value = PostgreSQLSerialization.getValue(arrayResultSet, new AtomicInteger(2), handler);
                    if (value instanceof PGStruct) {
                        list.add(PostgreSQLSerialization.instantiateObject(((ObjectTypeHandler)handler).getLayout(), (PGStruct)value));
                        continue;
                    }
                    list.add(value);
                }
                ArrayList<Object> arrayList = list;
                return arrayList;
            }
        }
        if (typeHandler instanceof LongTypeHandler) {
            return resultSet.getLong(i.getAndIncrement());
        }
        if (typeHandler instanceof ObjectTypeHandler) {
            Layout layout = ((ObjectTypeHandler)typeHandler).getLayout();
            PGStruct struct = (PGStruct)resultSet.getObject(i.getAndIncrement());
            return PostgreSQLSerialization.instantiateObject(layout, struct);
        }
        if (typeHandler instanceof OptionalTypeHandler) {
            return Optional.ofNullable(PostgreSQLSerialization.getValue(resultSet, i, ((OptionalTypeHandler)typeHandler).getWrappedHandler()));
        }
        if (typeHandler instanceof ShortTypeHandler) {
            return resultSet.getShort(i.getAndIncrement());
        }
        if (typeHandler instanceof StringTypeHandler) {
            return resultSet.getString(i.getAndIncrement());
        }
        if (!(typeHandler instanceof UUIDTypeHandler)) throw new RuntimeException("Unsupported type handler " + typeHandler.getClass());
        return UUID.fromString(resultSet.getString(i.getAndIncrement()));
    }

    public static String getParameter(Connection connection, TypeHandler typeHandler, Object object) {
        if (typeHandler instanceof UUIDTypeHandler) {
            return "?::UUID";
        }
        if (typeHandler instanceof OptionalTypeHandler) {
            if (object == null || !((Optional)object).isPresent()) {
                return "?";
            }
            return PostgreSQLSerialization.getParameter(connection, ((OptionalTypeHandler)typeHandler).getWrappedHandler(), ((Optional)object).get());
        }
        return "?";
    }

    private static class ObjectArrayCollector
    implements Function<Map<String, Object>, Object> {
        private final Layout objectLayout;
        private final List<? extends Property<?>> properties;

        public ObjectArrayCollector(Layout<?> objectLayout, List<? extends Property<?>> properties) {
            this.objectLayout = objectLayout;
            this.properties = properties;
        }

        @Override
        public Object apply(Map<String, Object> map) {
            HashMap props = new HashMap();
            for (Property<?> property : this.properties) {
                props.put(property, map.get(property.getName()));
            }
            Object o = this.objectLayout.instantiate(props);
            return o;
        }
    }
}

