/*
 * Decompiled with CFR 0.152.
 */
package com.eventsourcing.postgresql;

import com.googlecode.cqengine.index.support.CloseableIterator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public abstract class PostgreSQLStatementIterator<T>
implements CloseableIterator<T> {
    protected ResultSet resultSet;
    protected final PreparedStatement statement;
    protected final Connection connection;
    private boolean nextCalled = true;

    public PostgreSQLStatementIterator(PreparedStatement statement, Connection connection, boolean lazy) {
        this.statement = statement;
        this.connection = connection;
        if (!lazy) {
            this.resultSet = statement.executeQuery();
        }
    }

    public boolean hasNext() {
        if (this.resultSet == null) {
            this.resultSet = this.statement.executeQuery();
        }
        if (this.nextCalled) {
            this.nextCalled = false;
            if (this.resultSet.next()) {
                return true;
            }
            this.close();
            return false;
        }
        return true;
    }

    public T next() {
        this.nextCalled = true;
        return this.fetchNext();
    }

    protected abstract T fetchNext();

    public void close() {
        if (this.resultSet != null && !this.resultSet.isClosed()) {
            this.resultSet.close();
        }
        if (!this.statement.isClosed()) {
            this.statement.close();
        }
        if (!this.connection.isClosed()) {
            this.connection.close();
        }
    }
}

