/*
 * Decompiled with CFR 0.152.
 */
package com.eventsourcing.postgresql.index;

import com.eventsourcing.Entity;
import com.eventsourcing.EntityHandle;
import com.eventsourcing.index.Attribute;
import com.eventsourcing.index.ReflectableAttribute;
import com.eventsourcing.layout.Layout;
import com.eventsourcing.layout.TypeHandler;
import com.eventsourcing.postgresql.PostgreSQLSerialization;
import com.eventsourcing.postgresql.index.PostgreSQLAttributeIndex;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.io.BaseEncoding;
import com.googlecode.cqengine.index.support.KeyStatisticsAttributeIndex;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.query.simple.Has;
import com.googlecode.cqengine.resultset.ResultSet;
import java.lang.reflect.Type;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EqualityIndex<A, O extends Entity>
extends PostgreSQLAttributeIndex<A, O>
implements KeyStatisticsAttributeIndex<A, EntityHandle<O>> {
    private static final Logger log = LoggerFactory.getLogger(EqualityIndex.class);
    protected static final int INDEX_RETRIEVAL_COST = 30;
    protected static final int UNIQUE_INDEX_RETRIEVAL_COST = 25;
    private final DataSource dataSource;
    private String tableName;
    private Layout<O> layout;
    private final TypeHandler attributeTypeHandler;
    private final boolean unique;

    public static <A, O extends Entity> EqualityIndex<A, O> onAttribute(DataSource dataSource, Attribute<O, A> attribute, boolean unique) {
        return new EqualityIndex<A, O>(dataSource, attribute, unique);
    }

    protected EqualityIndex(DataSource dataSource, Attribute<O, A> attribute, boolean unique) {
        super(attribute, (Set<Class<? extends Query>>)new HashSet<Class<? extends Query>>(){
            {
                this.add(Equal.class);
                this.add(Has.class);
            }
        });
        this.dataSource = dataSource;
        this.unique = unique;
        this.layout = Layout.forClass((Class)attribute.getEffectiveObjectType());
        TypeResolver typeResolver = new TypeResolver();
        ResolvedType resolvedType = attribute instanceof ReflectableAttribute ? typeResolver.resolve(((ReflectableAttribute)attribute).getAttributeReflectedType(), new Type[0]) : typeResolver.resolve((Type)attribute.getAttributeType(), new Type[0]);
        this.attributeTypeHandler = TypeHandler.lookup((ResolvedType)resolvedType);
        this.init();
    }

    private void init() {
        try (Connection connection = this.dataSource.getConnection();){
            Throwable throwable;
            PreparedStatement s;
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(this.layout.getHash());
            digest.update(this.attribute.getAttributeName().getBytes());
            String encodedHash = BaseEncoding.base16().encode(digest.digest());
            this.tableName = "index_v1_" + encodedHash + "_eq";
            if (this.unique) {
                this.tableName = this.tableName + "_unique";
            }
            String attributeType = PostgreSQLSerialization.getMappedType(connection, this.attributeTypeHandler);
            if (this.unique) {
                attributeType = attributeType + " UNIQUE";
            }
            String create = "CREATE TABLE IF NOT EXISTS " + this.getTableName() + " (\"key\" " + attributeType + ",\n\"object\" UUID,\nPRIMARY KEY(\"key\", \"object\"))";
            try (PreparedStatement s2 = connection.prepareStatement(create);){
                s2.executeUpdate();
            }
            if (!this.unique) {
                String indexKey = "CREATE INDEX IF NOT EXISTS " + this.getTableName() + "_key_idx ON " + this.getTableName() + " (\"key\")";
                s = connection.prepareStatement(indexKey);
                throwable = null;
                try {
                    s.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (s != null) {
                        if (throwable != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            s.close();
                        }
                    }
                }
            }
            String indexObj = "CREATE INDEX IF NOT EXISTS " + this.getTableName() + "_obj_idx ON " + this.getTableName() + " (\"object\")";
            s = connection.prepareStatement(indexObj);
            throwable = null;
            try {
                s.executeUpdate();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (s != null) {
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        s.close();
                    }
                }
            }
            String indexComment = this.layout.getName() + "." + this.attribute.getAttributeName() + " EQ";
            if (this.unique) {
                indexComment = indexComment + " UNIQUE";
            }
            String comment = "COMMENT ON TABLE " + this.getTableName() + " IS '" + indexComment + "'";
            try (PreparedStatement s3 = connection.prepareStatement(comment);){
                s3.executeUpdate();
            }
        }
    }

    @Override
    public ResultSet<EntityHandle<O>> retrieve(Query<EntityHandle<O>> query, QueryOptions queryOptions) {
        return super.retrieve(query, queryOptions);
    }

    public String toString() {
        return "EqualityIndex[PostgreSQL, table=" + this.getTableName() + "]";
    }

    @Override
    protected int indexRetrievalCost() {
        return this.isUnique() ? 25 : 30;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Layout<O> getLayout() {
        return this.layout;
    }

    @Override
    public TypeHandler getAttributeTypeHandler() {
        return this.attributeTypeHandler;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }
}

