/*
 * Decompiled with CFR 0.152.
 */
package com.eventsourcing.postgresql.index;

import com.eventsourcing.Entity;
import com.eventsourcing.EntityHandle;
import com.eventsourcing.index.Attribute;
import com.eventsourcing.layout.Layout;
import com.eventsourcing.layout.TypeHandler;
import com.eventsourcing.postgresql.PostgreSQLSerialization;
import com.eventsourcing.postgresql.PostgreSQLStatementIterator;
import com.eventsourcing.postgresql.index.PostgreSQLAttributeIndex;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.io.BaseEncoding;
import com.googlecode.cqengine.index.support.SortedKeyStatisticsAttributeIndex;
import com.googlecode.cqengine.quantizer.Quantizer;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.Between;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.query.simple.GreaterThan;
import com.googlecode.cqengine.query.simple.Has;
import com.googlecode.cqengine.query.simple.LessThan;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.closeable.CloseableResultSet;
import com.googlecode.cqengine.resultset.filter.QuantizedResultSet;
import java.lang.reflect.Type;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.sql.DataSource;

public class NavigableIndex<A extends Comparable<A>, O extends Entity>
extends PostgreSQLAttributeIndex<A, O>
implements SortedKeyStatisticsAttributeIndex<A, EntityHandle<O>> {
    protected static final int INDEX_RETRIEVAL_COST = 40;
    private final DataSource dataSource;
    private final Layout<O> layout;
    private final TypeHandler attributeTypeHandler;
    private String tableName;

    @Override
    protected boolean isUnique() {
        return false;
    }

    public static <A extends Comparable<A>, O extends Entity> NavigableIndex<A, O> onAttribute(DataSource dataSource, Attribute<O, A> attribute) {
        return new NavigableIndex(dataSource, NavigableIndex.serializableComparable(attribute));
    }

    public static <A extends Comparable<A>, O extends Entity> NavigableIndex<A, O> withQuantizerOnAttribute(DataSource dataSource, final Quantizer<A> quantizer, Attribute<O, A> attribute) {
        return new NavigableIndex<A, O>(dataSource, NavigableIndex.serializableComparable(attribute)){

            @Override
            public boolean isQuantized() {
                return true;
            }

            @Override
            protected A getQuantizedValue(A attributeValue) {
                return (Comparable)quantizer.getQuantizedValue(attributeValue);
            }

            @Override
            public ResultSet<EntityHandle<O>> retrieve(Query<EntityHandle<O>> query, QueryOptions queryOptions) {
                ResultSet rs = super.retrieve(query, queryOptions);
                return new QuantizedResultSet(rs, query, queryOptions);
            }
        };
    }

    protected NavigableIndex(DataSource dataSource, Attribute<O, A> attribute) {
        super(attribute, (Set<Class<? extends Query>>)new HashSet<Class<? extends Query>>(){
            {
                this.add(Equal.class);
                this.add(LessThan.class);
                this.add(GreaterThan.class);
                this.add(Between.class);
                this.add(Has.class);
            }
        });
        this.dataSource = dataSource;
        this.layout = Layout.forClass((Class)attribute.getEffectiveObjectType());
        TypeResolver typeResolver = new TypeResolver();
        ResolvedType resolvedType = typeResolver.resolve((Type)attribute.getAttributeType(), new Type[0]);
        this.attributeTypeHandler = TypeHandler.lookup((ResolvedType)resolvedType);
        this.init();
    }

    private void init() {
        try (Connection connection = this.dataSource.getConnection();){
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(this.layout.getHash());
            digest.update(this.attribute.getAttributeName().getBytes());
            String encodedHash = BaseEncoding.base16().encode(digest.digest());
            this.tableName = "index_v1_" + encodedHash + "_navigable";
            String attributeType = PostgreSQLSerialization.getMappedType(connection, this.attributeTypeHandler);
            String create = "CREATE TABLE IF NOT EXISTS " + this.tableName + " (\"key\" " + attributeType + ",\n\"object\" UUID,PRIMARY KEY(\"key\", \"object\"))";
            try (PreparedStatement s = connection.prepareStatement(create);){
                s.executeUpdate();
            }
            String indexKey = "CREATE INDEX IF NOT EXISTS " + this.tableName + "_key_idx ON " + this.tableName + " (\"key\")";
            try (PreparedStatement s = connection.prepareStatement(indexKey);){
                s.executeUpdate();
            }
            String indexObj = "CREATE INDEX IF NOT EXISTS " + this.tableName + "_obj_idx ON " + this.tableName + " (\"object\")";
            try (PreparedStatement s = connection.prepareStatement(indexObj);){
                s.executeUpdate();
            }
            String indexComment = this.layout.getName() + "." + this.attribute.getAttributeName() + " EQ LT GT BT";
            String comment = "COMMENT ON TABLE " + this.tableName + " IS '" + indexComment + "'";
            try (PreparedStatement s = connection.prepareStatement(comment);){
                s.executeUpdate();
            }
        }
    }

    @Override
    public ResultSet<EntityHandle<O>> retrieve(Query<EntityHandle<O>> query, QueryOptions queryOptions) {
        Class<?> queryClass = query.getClass();
        if (queryClass.equals(LessThan.class)) {
            LessThan lessThan = (LessThan)query;
            Connection connection = this.getDataSource().getConnection();
            String op = lessThan.isValueInclusive() || this.isQuantized() ? "<=" : "<";
            int size = 0;
            Comparable value = this.getQuantizedValue(((LessThan)query).getValue());
            try (PreparedStatement counter = connection.prepareStatement("SELECT count(object) FROM " + this.getTableName() + " WHERE key " + op + " " + PostgreSQLSerialization.getParameter(connection, this.getAttributeTypeHandler(), null));){
                PostgreSQLSerialization.setValue(connection, counter, 1, value, this.getAttributeTypeHandler());
                try (java.sql.ResultSet resultSet = counter.executeQuery();){
                    resultSet.next();
                    size = resultSet.getInt(1);
                }
            }
            PreparedStatement s = connection.prepareStatement("SELECT object FROM " + this.getTableName() + " WHERE key " + op + " " + PostgreSQLSerialization.getParameter(connection, this.getAttributeTypeHandler(), null));
            PostgreSQLSerialization.setValue(connection, s, 1, value, this.getAttributeTypeHandler());
            PostgreSQLStatementIterator iterator = new PostgreSQLStatementIterator<EntityHandle<O>>(s, connection, this.isMutable()){

                @Override
                public EntityHandle<O> fetchNext() {
                    UUID uuid = UUID.fromString(this.resultSet.getString(1));
                    return (EntityHandle)NavigableIndex.this.keyObjectStore.get((Object)uuid);
                }
            };
            int finalSize = size;
            PostgreSQLAttributeIndex.MatchingResultSet rs = new PostgreSQLAttributeIndex.MatchingResultSet((PostgreSQLAttributeIndex)this, iterator, (Query)lessThan, queryOptions, finalSize);
            return new CloseableResultSet((ResultSet)rs, query, queryOptions);
        }
        if (queryClass.equals(GreaterThan.class)) {
            Object rs;
            GreaterThan greaterThan = (GreaterThan)query;
            Connection connection = this.getDataSource().getConnection();
            String op = greaterThan.isValueInclusive() || this.isQuantized() ? ">=" : ">";
            int size = 0;
            Comparable value = this.getQuantizedValue(((GreaterThan)query).getValue());
            PreparedStatement counter = connection.prepareStatement("SELECT count(object) FROM " + this.getTableName() + " WHERE key " + op + " " + PostgreSQLSerialization.getParameter(connection, this.getAttributeTypeHandler(), null));
            Object iterator = null;
            try {
                PostgreSQLSerialization.setValue(connection, counter, 1, value, this.getAttributeTypeHandler());
                rs = null;
                try (java.sql.ResultSet resultSet = counter.executeQuery();){
                    resultSet.next();
                    size = resultSet.getInt(1);
                }
                catch (Throwable throwable) {
                    rs = throwable;
                    throw throwable;
                }
            }
            catch (Throwable resultSet) {
                iterator = resultSet;
                throw resultSet;
            }
            finally {
                if (counter != null) {
                    if (iterator != null) {
                        try {
                            counter.close();
                        }
                        catch (Throwable resultSet) {
                            ((Throwable)iterator).addSuppressed(resultSet);
                        }
                    } else {
                        counter.close();
                    }
                }
            }
            PreparedStatement s = connection.prepareStatement("SELECT object FROM " + this.getTableName() + " WHERE key " + op + " " + PostgreSQLSerialization.getParameter(connection, this.getAttributeTypeHandler(), null));
            PostgreSQLSerialization.setValue(connection, s, 1, value, this.getAttributeTypeHandler());
            iterator = new PostgreSQLStatementIterator<EntityHandle<O>>(s, connection, this.isMutable()){

                @Override
                public EntityHandle<O> fetchNext() {
                    UUID uuid = UUID.fromString(this.resultSet.getString(1));
                    return (EntityHandle)NavigableIndex.this.keyObjectStore.get((Object)uuid);
                }
            };
            int finalSize = size;
            rs = new PostgreSQLAttributeIndex.MatchingResultSet((PostgreSQLAttributeIndex)this, (PostgreSQLStatementIterator)iterator, (Query)greaterThan, queryOptions, finalSize);
            return new CloseableResultSet((ResultSet)rs, query, queryOptions);
        }
        if (queryClass.equals(Between.class)) {
            Between between = (Between)query;
            Connection connection = this.getDataSource().getConnection();
            String lowerOp = between.isLowerInclusive() || this.isQuantized() ? ">=" : ">";
            String upperOp = between.isUpperInclusive() || this.isQuantized() ? "<=" : "<";
            int size = 0;
            Comparable lowerValue = this.getQuantizedValue(((Between)query).getLowerValue());
            Comparable upperValue = this.getQuantizedValue(((Between)query).getUpperValue());
            String parameter = PostgreSQLSerialization.getParameter(connection, this.getAttributeTypeHandler(), null);
            try (PreparedStatement counter = connection.prepareStatement("SELECT count(object) FROM " + this.getTableName() + " WHERE key " + lowerOp + " " + parameter + " AND key " + upperOp + " " + parameter);){
                PostgreSQLSerialization.setValue(connection, counter, 1, lowerValue, this.getAttributeTypeHandler());
                PostgreSQLSerialization.setValue(connection, counter, 2, upperValue, this.getAttributeTypeHandler());
                try (java.sql.ResultSet resultSet = counter.executeQuery();){
                    resultSet.next();
                    size = resultSet.getInt(1);
                }
            }
            PreparedStatement s = connection.prepareStatement("SELECT object FROM " + this.getTableName() + " WHERE key " + lowerOp + " " + parameter + " AND key " + upperOp + " " + parameter);
            PostgreSQLSerialization.setValue(connection, s, 1, lowerValue, this.getAttributeTypeHandler());
            PostgreSQLSerialization.setValue(connection, s, 2, upperValue, this.getAttributeTypeHandler());
            PostgreSQLStatementIterator iterator = new PostgreSQLStatementIterator<EntityHandle<O>>(s, connection, this.isMutable()){

                @Override
                public EntityHandle<O> fetchNext() {
                    UUID uuid = UUID.fromString(this.resultSet.getString(1));
                    return (EntityHandle)NavigableIndex.this.keyObjectStore.get((Object)uuid);
                }
            };
            final int finalSize = size;
            PostgreSQLAttributeIndex.MatchingResultSet rs = new PostgreSQLAttributeIndex.MatchingResultSet<O, Between<EntityHandle<O>, A>>(iterator, between, queryOptions, finalSize){

                @Override
                public int getMergeCost() {
                    return finalSize;
                }
            };
            return new CloseableResultSet((ResultSet)rs, query, queryOptions);
        }
        return super.retrieve(query, queryOptions);
    }

    @Override
    protected int indexRetrievalCost() {
        return 40;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Layout<O> getLayout() {
        return this.layout;
    }

    @Override
    public TypeHandler getAttributeTypeHandler() {
        return this.attributeTypeHandler;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }
}

