/*
 * Decompiled with CFR 0.152.
 */
package com.eventsourcing.postgresql.index;

import com.eventsourcing.Entity;
import com.eventsourcing.EntityHandle;
import com.eventsourcing.ResolvedEntityHandle;
import com.eventsourcing.index.AbstractAttributeIndex;
import com.eventsourcing.index.Attribute;
import com.eventsourcing.index.KeyObjectStore;
import com.eventsourcing.index.MultiValueAttribute;
import com.eventsourcing.layout.Layout;
import com.eventsourcing.layout.SerializableComparable;
import com.eventsourcing.layout.TypeHandler;
import com.eventsourcing.postgresql.PostgreSQLSerialization;
import com.eventsourcing.postgresql.PostgreSQLStatementIterator;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.support.CloseableIterable;
import com.googlecode.cqengine.index.support.CloseableIterator;
import com.googlecode.cqengine.index.support.KeyStatistics;
import com.googlecode.cqengine.index.support.KeyValue;
import com.googlecode.cqengine.index.support.KeyValueMaterialized;
import com.googlecode.cqengine.index.unique.UniqueIndex;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.query.simple.Has;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.closeable.CloseableResultSet;
import com.impossibl.postgres.jdbc.PGSQLIntegrityConstraintViolationException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;

public abstract class PostgreSQLAttributeIndex<A, O extends Entity>
extends AbstractAttributeIndex<A, O> {
    protected KeyObjectStore<UUID, EntityHandle<O>> keyObjectStore;

    protected static <A, O extends Entity> Attribute<O, ?> serializableComparable(Attribute<O, A> attribute) {
        if (SerializableComparable.class.isAssignableFrom(attribute.getAttributeType())) {
            Class type = SerializableComparable.getType((Class)attribute.getAttributeType());
            SerializableComparableAttribute<O, A> newAttribute = new SerializableComparableAttribute<O, A>(attribute, type);
            return newAttribute;
        }
        return attribute;
    }

    protected PostgreSQLAttributeIndex(Attribute<O, A> attribute, Set<Class<? extends Query>> supportedQueries) {
        super(attribute, supportedQueries);
    }

    protected abstract DataSource getDataSource();

    protected abstract Layout<O> getLayout();

    protected abstract String getTableName();

    protected abstract TypeHandler getAttributeTypeHandler();

    protected abstract boolean isUnique();

    public CloseableIterable<A> getDistinctKeys(QueryOptions queryOptions) {
        Connection connection = this.getDataSource().getConnection();
        PreparedStatement s = connection.prepareStatement("SELECT DISTINCT key FROM " + this.getTableName() + " ORDER BY key");
        return () -> new PostgreSQLStatementIterator<A>(s, connection, true){

            @Override
            public A fetchNext() {
                return PostgreSQLSerialization.getValue(this.resultSet, new AtomicInteger(1), PostgreSQLAttributeIndex.this.getAttributeTypeHandler());
            }
        };
    }

    /*
     * Exception decompiling
     */
    public Integer getCountForKey(A key, QueryOptions queryOptions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Integer getCountOfDistinctKeys(QueryOptions queryOptions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CloseableIterable<KeyStatistics<A>> getStatisticsForDistinctKeys(QueryOptions queryOptions) {
        return this.getKeyStatisticsForDistinctKeys("ASC");
    }

    public CloseableIterable<KeyStatistics<A>> getStatisticsForDistinctKeysDescending(QueryOptions queryOptions) {
        return this.getKeyStatisticsForDistinctKeys("DESC");
    }

    protected CloseableIterable<KeyStatistics<A>> getKeyStatisticsForDistinctKeys(String order) throws SQLException {
        final Connection connection = this.getDataSource().getConnection();
        final PreparedStatement s = connection.prepareStatement("SELECT DISTINCT key, COUNT(key) FROM " + this.getTableName() + " GROUP BY key ORDER BY key " + order);
        return new CloseableIterable<KeyStatistics<A>>(){

            public CloseableIterator<KeyStatistics<A>> iterator() {
                return new PostgreSQLStatementIterator<KeyStatistics<A>>(s, connection, true){

                    @Override
                    public KeyStatistics<A> fetchNext() {
                        Object key = PostgreSQLSerialization.getValue(this.resultSet, new AtomicInteger(1), PostgreSQLAttributeIndex.this.getAttributeTypeHandler());
                        int count = this.resultSet.getInt(2);
                        return new KeyStatistics(key, Integer.valueOf(count));
                    }
                };
            }
        };
    }

    public CloseableIterable<KeyValue<A, EntityHandle<O>>> getKeysAndValues(QueryOptions queryOptions) {
        return this.queryKeysAndValues("ASC");
    }

    protected CloseableIterable<KeyValue<A, EntityHandle<O>>> queryKeysAndValues(String order) throws SQLException {
        final Connection connection = this.getDataSource().getConnection();
        final PreparedStatement s = connection.prepareStatement("SELECT key, value FROM " + this.getTableName() + " ORDER BY key " + order);
        return new CloseableIterable<KeyValue<A, EntityHandle<O>>>(){

            public CloseableIterator<KeyValue<A, EntityHandle<O>>> iterator() {
                return new PostgreSQLStatementIterator<KeyValue<A, EntityHandle<O>>>(s, connection, true){

                    @Override
                    public KeyValue<A, EntityHandle<O>> fetchNext() {
                        AtomicInteger i = new AtomicInteger(1);
                        Object key = PostgreSQLSerialization.getValue(this.resultSet, i, PostgreSQLAttributeIndex.this.getAttributeTypeHandler());
                        UUID uuid = UUID.fromString(this.resultSet.getString(i.get()));
                        return new KeyValueMaterialized(key, PostgreSQLAttributeIndex.this.keyObjectStore.get((Object)uuid));
                    }
                };
            }
        };
    }

    public CloseableIterable<KeyValue<A, EntityHandle<O>>> getKeysAndValuesDescending(QueryOptions queryOptions) {
        return this.queryKeysAndValues("DESC");
    }

    public boolean isMutable() {
        return true;
    }

    public boolean isQuantized() {
        return false;
    }

    public Index<EntityHandle<O>> getEffectiveIndex() {
        return this;
    }

    public boolean addAll(ObjectSet<EntityHandle<O>> objectSet, QueryOptions queryOptions) {
        try (CloseableIterator iterator = objectSet.iterator();){
            boolean bl = this.addAll((Iterator<EntityHandle<O>>)iterator, queryOptions);
            return bl;
        }
    }

    public boolean addAll(Iterator<EntityHandle<O>> iterator, QueryOptions queryOptions) {
        try (Connection connection = this.getDataSource().getConnection();){
            connection.setAutoCommit(false);
            String insert = "INSERT INTO " + this.getTableName() + " VALUES (" + PostgreSQLSerialization.getParameter(connection, this.getAttributeTypeHandler(), null) + ", ?::UUID) " + (queryOptions.get(OnConflictDo.class) == null ? "" : "ON CONFLICT DO " + queryOptions.get(OnConflictDo.class));
            try (PreparedStatement s = connection.prepareStatement(insert);){
                while (iterator.hasNext()) {
                    EntityHandle<O> object = iterator.next();
                    Iterator attrIterator = this.attribute.getValues(object, queryOptions).iterator();
                    while (attrIterator.hasNext()) {
                        int i = 1;
                        Object attr = attrIterator.next();
                        i = PostgreSQLSerialization.setValue(connection, s, i, this.getQuantizedValue(attr), this.getAttributeTypeHandler());
                        s.setString(i, object.uuid().toString());
                        s.addBatch();
                    }
                }
                try {
                    s.executeBatch();
                }
                catch (BatchUpdateException e) {
                    connection.rollback();
                    Throwable nextException = e.getCause();
                    if (nextException instanceof PGSQLIntegrityConstraintViolationException) {
                        if (nextException.getMessage().contains("duplicate key value violates unique constraint")) {
                            throw new UniqueIndex.UniqueConstraintViolatedException(nextException.getMessage());
                        }
                        throw e;
                    }
                    throw e;
                }
            }
            connection.commit();
        }
        return true;
    }

    protected void addAll(ObjectStore<EntityHandle<O>> objectStore, QueryOptions queryOptions) {
        this.addAll((Iterator<EntityHandle<O>>)objectStore.iterator(queryOptions), queryOptions);
    }

    public boolean removeAll(ObjectSet<EntityHandle<O>> objects, QueryOptions queryOptions) {
        try (Connection connection = this.getDataSource().getConnection();){
            String insert = "DELETE FROM " + this.getTableName() + " WHERE object = ?::UUID";
            try (PreparedStatement s = connection.prepareStatement(insert);){
                try (CloseableIterator iterator = objects.iterator();){
                    while (iterator.hasNext()) {
                        EntityHandle object = (EntityHandle)iterator.next();
                        s.setString(1, object.uuid().toString());
                        s.addBatch();
                    }
                }
                s.executeBatch();
            }
        }
        return true;
    }

    public void clear(QueryOptions queryOptions) {
        try (Connection connection = this.getDataSource().getConnection();
             PreparedStatement s = connection.prepareStatement("DELETE FROM " + this.getTableName());){
            s.executeUpdate();
        }
    }

    public void init(ObjectStore<EntityHandle<O>> objectStore, QueryOptions queryOptions) {
        this.keyObjectStore = objectStore instanceof KeyObjectStore ? (KeyObjectStore)objectStore : new SetKeyObjectStore(objectStore, queryOptions);
        queryOptions.put(OnConflictDo.class, (Object)OnConflictDo.NOTHING);
        this.addAll(objectStore, queryOptions);
    }

    public CloseableIterable<A> getDistinctKeys(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.queryDistinctKeys(lowerBound, lowerInclusive, upperBound, upperInclusive, "ASC");
    }

    protected CloseableIterable<A> queryDistinctKeys(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, String order) throws SQLException {
        Connection connection = this.getDataSource().getConnection();
        String lowerOp = lowerInclusive ? ">=" : ">";
        String upperOp = upperInclusive ? "<=" : "<";
        String query = "SELECT DISTINCT key FROM " + this.getTableName() + " WHERE key " + lowerOp + " ? AND key " + upperOp + " ? ORDER BY key " + order;
        PreparedStatement s = connection.prepareStatement(query);
        int i = PostgreSQLSerialization.setValue(connection, s, 1, lowerBound, this.getAttributeTypeHandler());
        PostgreSQLSerialization.setValue(connection, s, i, upperBound, this.getAttributeTypeHandler());
        return () -> new PostgreSQLStatementIterator<A>(s, connection, true){

            @Override
            public A fetchNext() {
                return PostgreSQLSerialization.getValue(this.resultSet, new AtomicInteger(1), PostgreSQLAttributeIndex.this.getAttributeTypeHandler());
            }
        };
    }

    public CloseableIterable<A> getDistinctKeysDescending(QueryOptions queryOptions) {
        Connection connection = this.getDataSource().getConnection();
        PreparedStatement s = connection.prepareStatement("SELECT DISTINCT key FROM " + this.getTableName() + " ORDER BY key DESC");
        return () -> new PostgreSQLStatementIterator<A>(s, connection, true){

            @Override
            public A fetchNext() {
                return PostgreSQLSerialization.getValue(this.resultSet, new AtomicInteger(1), PostgreSQLAttributeIndex.this.getAttributeTypeHandler());
            }
        };
    }

    public CloseableIterable<A> getDistinctKeysDescending(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.queryDistinctKeys(lowerBound, lowerInclusive, upperBound, upperInclusive, "DESC");
    }

    public CloseableIterable<KeyValue<A, EntityHandle<O>>> getKeysAndValues(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.queryKeysAndValues(lowerBound, lowerInclusive, upperBound, upperInclusive, queryOptions, "ASC");
    }

    public CloseableIterable<KeyValue<A, EntityHandle<O>>> getKeysAndValuesDescending(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.queryKeysAndValues(lowerBound, lowerInclusive, upperBound, upperInclusive, queryOptions, "DESC");
    }

    protected CloseableIterable<KeyValue<A, EntityHandle<O>>> queryKeysAndValues(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptionsString, String order) throws SQLException {
        final Connection connection = this.getDataSource().getConnection();
        String lowerOp = lowerInclusive ? ">=" : ">";
        String upperOp = upperInclusive ? "<=" : "<";
        String sql = "SELECT key, value FROM " + this.getTableName() + " WHERE key " + lowerOp + " ? AND key " + upperOp + " ?  ORDER BY key " + order;
        final PreparedStatement s = connection.prepareStatement(sql);
        return new CloseableIterable<KeyValue<A, EntityHandle<O>>>(){

            public CloseableIterator<KeyValue<A, EntityHandle<O>>> iterator() {
                return new PostgreSQLStatementIterator<KeyValue<A, EntityHandle<O>>>(s, connection, true){

                    @Override
                    public KeyValue<A, EntityHandle<O>> fetchNext() {
                        AtomicInteger i = new AtomicInteger(1);
                        Object key = PostgreSQLSerialization.getValue(this.resultSet, i, PostgreSQLAttributeIndex.this.getAttributeTypeHandler());
                        UUID uuid = UUID.fromString(this.resultSet.getString(i.get()));
                        return new KeyValueMaterialized(key, PostgreSQLAttributeIndex.this.keyObjectStore.get((Object)uuid));
                    }
                };
            }
        };
    }

    public ResultSet<EntityHandle<O>> retrieve(Query<EntityHandle<O>> query, QueryOptions queryOptions) {
        Class<?> queryClass = query.getClass();
        if (queryClass.equals(Equal.class)) {
            int size;
            Equal equal = (Equal)query;
            Connection connection = this.getDataSource().getConnection();
            Object value = ((Equal)query).getValue();
            try (PreparedStatement counter = connection.prepareStatement("SELECT count(object) FROM " + this.getTableName() + " WHERE key = " + PostgreSQLSerialization.getParameter(connection, this.getAttributeTypeHandler(), null));){
                PostgreSQLSerialization.setValue(connection, counter, 1, value, this.getAttributeTypeHandler());
                try (java.sql.ResultSet resultSet = counter.executeQuery();){
                    resultSet.next();
                    size = resultSet.getInt(1);
                }
            }
            PreparedStatement s = connection.prepareStatement("SELECT object FROM " + this.getTableName() + " WHERE key = " + PostgreSQLSerialization.getParameter(connection, this.getAttributeTypeHandler(), null));
            PostgreSQLSerialization.setValue(connection, s, 1, value, this.getAttributeTypeHandler());
            PostgreSQLStatementIterator iterator = new PostgreSQLStatementIterator<EntityHandle<O>>(s, connection, this.isMutable()){

                @Override
                public EntityHandle<O> fetchNext() {
                    UUID uuid = UUID.fromString(this.resultSet.getString(1));
                    return (EntityHandle)PostgreSQLAttributeIndex.this.keyObjectStore.get((Object)uuid);
                }
            };
            int finalSize = size;
            MatchingResultSet rs = new MatchingResultSet(this, iterator, (Query)equal, queryOptions, finalSize);
            return new CloseableResultSet((ResultSet)rs, query, queryOptions);
        }
        if (queryClass.equals(Has.class)) {
            int size;
            Has has = (Has)query;
            Connection connection = this.getDataSource().getConnection();
            try (PreparedStatement counter = connection.prepareStatement("SELECT count(object) FROM " + this.getTableName());
                 java.sql.ResultSet resultSet = counter.executeQuery();){
                resultSet.next();
                size = resultSet.getInt(1);
            }
            PreparedStatement s = connection.prepareStatement("SELECT object FROM " + this.getTableName());
            PostgreSQLStatementIterator iterator = new PostgreSQLStatementIterator<EntityHandle<O>>(s, connection, this.isMutable()){

                @Override
                public EntityHandle<O> fetchNext() {
                    UUID uuid = UUID.fromString(this.resultSet.getString(1));
                    return (EntityHandle)PostgreSQLAttributeIndex.this.keyObjectStore.get((Object)uuid);
                }
            };
            int finalSize = size;
            HasResultSet rs = new HasResultSet(iterator, has, queryOptions, finalSize);
            return new CloseableResultSet(rs, query, queryOptions);
        }
        throw new IllegalArgumentException("Unsupported query: " + query);
    }

    protected abstract int indexRetrievalCost();

    protected A getQuantizedValue(A attributeValue) {
        return attributeValue;
    }

    protected static enum OnConflictDo {
        UPDATE,
        NOTHING;

    }

    private class HasResultSet<O extends Entity>
    extends ResultSet<EntityHandle<O>> {
        private final PostgreSQLStatementIterator<EntityHandle<O>> iterator;
        private final Has<EntityHandle<O>, A> has;
        private final QueryOptions queryOptions;
        private final int finalSize;

        public HasResultSet(PostgreSQLStatementIterator<EntityHandle<O>> iterator, Has<EntityHandle<O>, A> has, QueryOptions queryOptions, int finalSize) {
            this.iterator = iterator;
            this.has = has;
            this.queryOptions = queryOptions;
            this.finalSize = finalSize;
        }

        public Iterator<EntityHandle<O>> iterator() {
            return this.iterator;
        }

        /*
         * Exception decompiling
         */
        public boolean contains(EntityHandle<O> object) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean matches(EntityHandle<O> object) {
            return this.has.matches(object, this.queryOptions);
        }

        public Query<EntityHandle<O>> getQuery() {
            return this.has;
        }

        public QueryOptions getQueryOptions() {
            return this.queryOptions;
        }

        public int getRetrievalCost() {
            return PostgreSQLAttributeIndex.this.indexRetrievalCost();
        }

        public int getMergeCost() {
            return this.finalSize;
        }

        public int size() {
            return this.finalSize;
        }

        public void close() {
            this.iterator.close();
        }
    }

    protected class MatchingResultSet<O extends Entity, T extends Query<EntityHandle<O>>>
    extends ResultSet<EntityHandle<O>> {
        private final PostgreSQLStatementIterator<EntityHandle<O>> iterator;
        private final T query;
        private final QueryOptions queryOptions;
        private final int finalSize;
        final /* synthetic */ PostgreSQLAttributeIndex this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public MatchingResultSet(PostgreSQLStatementIterator<EntityHandle<O>> iterator, T query, QueryOptions queryOptions, int finalSize) {
            this.this$0 = (PostgreSQLAttributeIndex)this$0;
            this.iterator = iterator;
            this.query = query;
            this.queryOptions = queryOptions;
            this.finalSize = finalSize;
        }

        public Iterator<EntityHandle<O>> iterator() {
            return this.iterator;
        }

        /*
         * Exception decompiling
         */
        public boolean contains(EntityHandle<O> object) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean matches(EntityHandle<O> object) {
            return this.query.matches(object, this.queryOptions);
        }

        public int getRetrievalCost() {
            return this.this$0.indexRetrievalCost();
        }

        public int getMergeCost() {
            return this.finalSize;
        }

        public int size() {
            return this.finalSize;
        }

        public void close() {
            this.iterator.close();
        }

        public T getQuery() {
            return this.query;
        }

        public QueryOptions getQueryOptions() {
            return this.queryOptions;
        }
    }

    class SetKeyObjectStore
    implements KeyObjectStore<UUID, EntityHandle<O>> {
        private final ObjectStore<EntityHandle<O>> objectStore;
        private final QueryOptions queryOptions;

        public SetKeyObjectStore(ObjectStore<EntityHandle<O>> objectStore, QueryOptions queryOptions) {
            this.objectStore = objectStore;
            this.queryOptions = queryOptions;
        }

        public EntityHandle<O> get(UUID key) {
            CloseableIterator iterator = this.objectStore.iterator(this.queryOptions);
            while (iterator.hasNext()) {
                EntityHandle next = (EntityHandle)iterator.next();
                if (!next.uuid().equals(key)) continue;
                return next;
            }
            return null;
        }
    }

    private static class SerializableComparableAttribute<O extends Entity, A>
    extends MultiValueAttribute<O, Object> {
        private final Attribute<O, A> attribute;

        public SerializableComparableAttribute(Attribute<O, A> attribute, Class<?> type) {
            super(attribute.getEffectiveObjectType(), attribute.getObjectType(), type, attribute.getAttributeName());
            this.attribute = attribute;
        }

        public Iterable<Object> getValues(Entity object, QueryOptions queryOptions) {
            Iterable iterable = this.attribute.getValues((Object)new ResolvedEntityHandle(object), queryOptions);
            ArrayList<Object> values = new ArrayList<Object>();
            for (Object value : iterable) {
                SerializableComparable value1 = (SerializableComparable)value;
                values.add(value1.getSerializableComparable());
            }
            return values;
        }
    }
}

