/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConnectionSettingsBuilder;
import com.eventstore.dbclient.Endpoint;
import com.eventstore.dbclient.NodePreference;
import com.eventstore.dbclient.UserCredentials;

public class EventStoreDBClientSettings {
    private boolean dnsDiscover;
    private int maxDiscoverAttempts;
    private int discoveryInterval;
    private int gossipTimeout;
    private NodePreference nodePreference;
    private boolean tls;
    private boolean tlsVerifyCert;
    private boolean throwOnAppendFailure;
    private Credentials defaultCredentials;
    private Endpoint[] hosts;
    private long keepAliveTimeout;
    private long keepAliveInterval;
    private Long defaultDeadline;

    public boolean isDnsDiscover() {
        return this.dnsDiscover;
    }

    public int getMaxDiscoverAttempts() {
        return this.maxDiscoverAttempts;
    }

    public int getDiscoveryInterval() {
        return this.discoveryInterval;
    }

    public int getGossipTimeout() {
        return this.gossipTimeout;
    }

    public NodePreference getNodePreference() {
        return this.nodePreference;
    }

    public boolean isTls() {
        return this.tls;
    }

    public boolean isTlsVerifyCert() {
        return this.tlsVerifyCert;
    }

    public boolean isThrowOnAppendFailure() {
        return this.throwOnAppendFailure;
    }

    public Credentials getDefaultCredentials() {
        return this.defaultCredentials;
    }

    public Endpoint[] getHosts() {
        return this.hosts;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public long getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public Long getDefaultDeadline() {
        return this.defaultDeadline;
    }

    public EventStoreDBClientSettings(boolean dnsDiscover, int maxDiscoverAttempts, int discoveryInterval, int gossipTimeout, NodePreference nodePreference, boolean tls, boolean tlsVerifyCert, boolean throwOnAppendFailure, Credentials defaultCredentials, Endpoint[] hosts, long keepAliveTimeout, long keepAliveInterval, Long defaultDeadline) {
        this.dnsDiscover = dnsDiscover;
        this.maxDiscoverAttempts = maxDiscoverAttempts;
        this.discoveryInterval = discoveryInterval;
        this.gossipTimeout = gossipTimeout;
        this.nodePreference = nodePreference;
        this.tls = tls;
        this.tlsVerifyCert = tlsVerifyCert;
        this.throwOnAppendFailure = throwOnAppendFailure;
        this.defaultCredentials = defaultCredentials;
        this.hosts = hosts;
        this.keepAliveTimeout = keepAliveTimeout;
        this.keepAliveInterval = keepAliveInterval;
        this.defaultDeadline = defaultDeadline;
    }

    public static ConnectionSettingsBuilder builder() {
        return new ConnectionSettingsBuilder();
    }

    protected static class Credentials {
        public String login;
        public String password;

        public Credentials(String login, String password) {
            this.login = login;
            this.password = password;
        }

        public UserCredentials toUserCredentials() {
            return new UserCredentials(this.login, this.password);
        }
    }
}

