/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConnectionMetadata;
import com.eventstore.dbclient.OperationKind;
import com.eventstore.dbclient.UserCredentials;
import io.grpc.Metadata;

class OptionsBase<T> {
    protected final ConnectionMetadata metadata = new ConnectionMetadata();
    protected Long deadline;
    protected OperationKind kind = OperationKind.Regular;
    private UserCredentials credentials;
    private boolean requiresLeader;

    protected OptionsBase() {
    }

    public Metadata getMetadata() {
        return this.metadata.build();
    }

    public boolean hasUserCredentials() {
        return this.metadata.hasUserCredentials();
    }

    public String getUserCredentials() {
        return this.metadata.getUserCredentials();
    }

    public T authenticated(UserCredentials credentials) {
        this.credentials = credentials;
        return (T)this;
    }

    public T requiresLeader() {
        return this.requiresLeader(true);
    }

    public T notRequireLeader() {
        return this.requiresLeader(false);
    }

    public T requiresLeader(boolean value) {
        this.requiresLeader = value;
        return (T)this;
    }

    public T deadline(long durationInMs) {
        this.deadline = durationInMs;
        return (T)this;
    }

    public Long getDeadline() {
        return this.deadline;
    }

    public OperationKind getKind() {
        return this.kind;
    }

    public boolean isLeaderRequired() {
        return this.requiresLeader;
    }

    public UserCredentials getCredentials() {
        return this.credentials;
    }
}

