/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.AbstractRead;
import com.eventstore.dbclient.Direction;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.ReadStreamOptions;
import com.eventstore.dbclient.proto.shared.Shared;
import com.eventstore.dbclient.proto.streams.StreamsOuterClass;

class ReadStream
extends AbstractRead {
    private final String streamName;
    private final ReadStreamOptions options;
    private final long maxCount;

    public ReadStream(GrpcClient client, String streamName, long maxCount, ReadStreamOptions options) {
        super(client, options);
        this.streamName = streamName;
        this.maxCount = maxCount;
        this.options = options;
    }

    @Override
    public StreamsOuterClass.ReadReq.Options.Builder createOptions() {
        return defaultReadOptions.clone().setStream(GrpcUtils.toStreamOptions(this.streamName, this.options.getStartingRevision())).setResolveLinks(this.options.shouldResolveLinkTos()).setCount(this.maxCount).setNoFilter(Shared.Empty.getDefaultInstance()).setReadDirection(this.options.getDirection() == Direction.Forwards ? StreamsOuterClass.ReadReq.Options.ReadDirection.Forwards : StreamsOuterClass.ReadReq.Options.ReadDirection.Backwards);
    }
}

