/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.RecordedEvent;
import com.eventstore.dbclient.proto.persistentsubscriptions.Persistent;
import com.eventstore.dbclient.proto.streams.StreamsOuterClass;
import java.util.Objects;

public class ResolvedEvent {
    private final RecordedEvent event;
    private final RecordedEvent link;

    public ResolvedEvent(RecordedEvent event, RecordedEvent link) {
        this.event = event;
        this.link = link;
    }

    public RecordedEvent getEvent() {
        return this.event;
    }

    public RecordedEvent getLink() {
        return this.link;
    }

    public RecordedEvent getOriginalEvent() {
        return this.link != null ? this.link : this.event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedEvent that = (ResolvedEvent)o;
        return this.event.equals(that.event) && Objects.equals(this.link, that.link);
    }

    public int hashCode() {
        return Objects.hash(this.event, this.link);
    }

    static ResolvedEvent fromWire(StreamsOuterClass.ReadResp.ReadEvent wireEvent) {
        RecordedEvent event = wireEvent.hasEvent() ? RecordedEvent.fromWire(wireEvent.getEvent()) : null;
        RecordedEvent link = wireEvent.hasLink() ? RecordedEvent.fromWire(wireEvent.getLink()) : null;
        return new ResolvedEvent(event, link);
    }

    static ResolvedEvent fromWire(Persistent.ReadResp.ReadEvent wireEvent) {
        RecordedEvent event = wireEvent.hasEvent() ? RecordedEvent.fromWire(wireEvent.getEvent()) : null;
        RecordedEvent link = wireEvent.hasLink() ? RecordedEvent.fromWire(wireEvent.getLink()) : null;
        return new ResolvedEvent(event, link);
    }
}

