/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.EventFilter;
import com.eventstore.dbclient.PrefixFilterExpression;
import com.eventstore.dbclient.RegularFilterExpression;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;

public class StreamFilter
implements EventFilter {
    private final PrefixFilterExpression[] prefixFilterExpressions;
    private final RegularFilterExpression regularFilterExpression;
    @NotNull
    private final Optional<Integer> maxSearchWindow;

    public StreamFilter(@NotNull Optional<Integer> maxSearchWindow, RegularFilterExpression regex) {
        this.maxSearchWindow = maxSearchWindow;
        this.regularFilterExpression = regex;
        this.prefixFilterExpressions = null;
    }

    public StreamFilter(@NotNull Optional<Integer> maxSearchWindow, PrefixFilterExpression ... prefixes) {
        this.maxSearchWindow = maxSearchWindow;
        this.prefixFilterExpressions = prefixes;
        this.regularFilterExpression = null;
    }

    @Override
    public PrefixFilterExpression[] getPrefixFilterExpressions() {
        return this.prefixFilterExpressions;
    }

    @Override
    public RegularFilterExpression getRegularFilterExpression() {
        return this.regularFilterExpression;
    }

    @Override
    public Optional<Integer> getMaxSearchWindow() {
        return this.maxSearchWindow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamFilter that = (StreamFilter)o;
        return Arrays.equals(this.prefixFilterExpressions, that.prefixFilterExpressions) && Objects.equals(this.regularFilterExpression, that.regularFilterExpression) && this.maxSearchWindow.equals(that.maxSearchWindow);
    }

    public int hashCode() {
        int result = Objects.hash(this.regularFilterExpression, this.maxSearchWindow);
        result = 31 * result + Arrays.hashCode(this.prefixFilterExpressions);
        return result;
    }
}

