/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.Acl;
import com.eventstore.dbclient.Acls;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class StreamMetadata {
    private Integer maxAge;
    private Integer truncateBefore;
    private Integer cacheControl;
    private Acl acl;
    private Integer maxCount;
    private HashMap<String, Object> customProperties;

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public Integer getTruncateBefore() {
        return this.truncateBefore;
    }

    public void setTruncateBefore(Integer truncateBefore) {
        this.truncateBefore = truncateBefore;
    }

    public Integer getCacheControl() {
        return this.cacheControl;
    }

    public void setCacheControl(Integer cacheControl) {
        this.cacheControl = cacheControl;
    }

    public Acl getAcl() {
        return this.acl;
    }

    public void setAcl(Acl acl) {
        this.acl = acl;
    }

    public Integer getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(Integer maxCount) {
        this.maxCount = maxCount;
    }

    public HashMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(HashMap<String, Object> customProperties) {
        this.customProperties = customProperties;
    }

    private static void insertValue(HashMap<String, Object> output, String key, Object value) {
        if (value != null) {
            output.put(key, value);
        }
    }

    public Object serialize() {
        HashMap<String, Object> output = new HashMap<String, Object>();
        StreamMetadata.insertValue(output, "$maxAge", this.maxAge);
        StreamMetadata.insertValue(output, "$maxCount", this.maxCount);
        StreamMetadata.insertValue(output, "$tb", this.truncateBefore);
        StreamMetadata.insertValue(output, "$cacheControl", this.cacheControl);
        if (this.acl != null) {
            StreamMetadata.insertValue(output, "$acl", this.acl.serialize());
        }
        if (this.customProperties != null) {
            this.customProperties.forEach((key, value) -> {
                if (key.startsWith("$")) {
                    return;
                }
                StreamMetadata.insertValue(output, key, value);
            });
        }
        return output;
    }

    public static StreamMetadata deserialize(HashMap<String, Object> source) {
        StreamMetadata metadata = new StreamMetadata();
        HashMap<String, Object> customProperties = null;
        block14: for (Map.Entry<String, Object> entry : source.entrySet()) {
            switch (entry.getKey()) {
                case "$maxAge": {
                    metadata.setMaxAge((Integer)entry.getValue());
                    continue block14;
                }
                case "$maxCount": {
                    metadata.setMaxCount((Integer)entry.getValue());
                    continue block14;
                }
                case "$tb": {
                    metadata.setTruncateBefore((Integer)entry.getValue());
                    continue block14;
                }
                case "$cacheControl": {
                    metadata.setCacheControl((Integer)entry.getValue());
                    continue block14;
                }
                case "$acl": {
                    metadata.setAcl(Acls.deserialize(entry.getValue()));
                    continue block14;
                }
            }
            customProperties = customProperties == null ? new HashMap<String, Object>() : customProperties;
            customProperties.put(entry.getKey(), entry.getValue());
        }
        metadata.setCustomProperties(customProperties);
        return metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamMetadata that = (StreamMetadata)o;
        return Objects.equals(this.maxAge, that.maxAge) && Objects.equals(this.truncateBefore, that.truncateBefore) && Objects.equals(this.cacheControl, that.cacheControl) && Objects.equals(this.acl, that.acl) && Objects.equals(this.maxCount, that.maxCount) && Objects.equals(this.customProperties, that.customProperties);
    }

    public int hashCode() {
        return Objects.hash(this.maxAge, this.truncateBefore, this.cacheControl, this.acl, this.maxCount, this.customProperties);
    }
}

