/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.Checkpointer;
import com.eventstore.dbclient.EventTypeFilter;
import com.eventstore.dbclient.PrefixFilterExpression;
import com.eventstore.dbclient.RegularFilterExpression;
import com.eventstore.dbclient.StreamFilter;
import com.eventstore.dbclient.SubscriptionFilter;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;

public class SubscriptionFilterBuilder {
    private int _checkpointIntervalUnsigned = 1;
    private Checkpointer _checkpointer = null;
    private FilterType _filterType = null;
    private Optional<Integer> _maxWindow;
    private RegularFilterExpression _regular = null;
    private PrefixFilterExpression _prefix = null;

    public SubscriptionFilterBuilder withMaxWindow(int maxWindow) {
        this._maxWindow = Optional.of(maxWindow);
        return this;
    }

    public SubscriptionFilterBuilder withStreamNameRegularExpression(@NotNull String pattern) {
        if (this._filterType != null) {
            throw new IllegalStateException(String.format("Filter type is already set to %s", this._filterType.name()));
        }
        this._filterType = FilterType.STREAM;
        this._regular = new RegularFilterExpression(Pattern.compile(pattern));
        return this;
    }

    public SubscriptionFilterBuilder withStreamNamePrefix(@NotNull String prefix) {
        if (this._filterType != null) {
            throw new IllegalStateException(String.format("Filter type is already set to %s", this._filterType.name()));
        }
        this._filterType = FilterType.STREAM;
        this._prefix = new PrefixFilterExpression(prefix);
        return this;
    }

    public SubscriptionFilterBuilder withEventTypeRegularExpression(@NotNull String pattern) {
        if (this._filterType != null) {
            throw new IllegalStateException(String.format("Filter type is already set to %s", this._filterType.name()));
        }
        this._filterType = FilterType.EVENT_TYPE;
        this._regular = new RegularFilterExpression(Pattern.compile(pattern));
        return this;
    }

    public SubscriptionFilterBuilder withEventTypePrefix(@NotNull String prefix) {
        if (this._filterType != null) {
            throw new IllegalStateException(String.format("Filter type is already set to %s", this._filterType.name()));
        }
        this._filterType = FilterType.EVENT_TYPE;
        this._prefix = new PrefixFilterExpression(prefix);
        return this;
    }

    public SubscriptionFilterBuilder withCheckpointer(@NotNull Checkpointer checkpointer, int intervalMultiplierUnsigned) {
        this._checkpointIntervalUnsigned = intervalMultiplierUnsigned;
        this._checkpointer = checkpointer;
        return this;
    }

    public SubscriptionFilterBuilder withCheckpointer(@NotNull Checkpointer checkpointer) {
        return this.withCheckpointer(checkpointer, 1);
    }

    public SubscriptionFilter build() {
        if (this._filterType == null) {
            throw new IllegalStateException("No filter type is specified");
        }
        switch (this._filterType) {
            case STREAM: {
                StreamFilter s;
                if (this._regular != null) {
                    s = new StreamFilter(this._maxWindow, this._regular);
                } else if (this._prefix != null) {
                    s = new StreamFilter(this._maxWindow, this._prefix);
                } else {
                    throw new IllegalStateException("Neither prefix or regular expression stream filter is configured");
                }
                return new SubscriptionFilter(s, this._checkpointIntervalUnsigned, this._checkpointer);
            }
            case EVENT_TYPE: {
                EventTypeFilter et;
                if (this._regular != null) {
                    et = new EventTypeFilter(this._maxWindow, this._regular);
                } else if (this._prefix != null) {
                    et = new EventTypeFilter(this._maxWindow, this._prefix);
                } else {
                    throw new IllegalStateException("Neither prefix or regular expression event type filter is configured");
                }
                return new SubscriptionFilter(et, this._checkpointIntervalUnsigned, this._checkpointer);
            }
        }
        throw new IllegalStateException(String.format("Unhandled filter type variant: %s", this._filterType.name()));
    }

    private static enum FilterType {
        STREAM,
        EVENT_TYPE;

    }
}

