/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConsumerStrategy;
import com.eventstore.dbclient.NamedConsumerStrategy;
import com.eventstore.dbclient.OptionsBase;
import com.eventstore.dbclient.PersistentSubscriptionSettings;
import java.time.Duration;

public class AbstractPersistentSubscriptionSettingsBuilder<T, TSettings extends PersistentSubscriptionSettings>
extends OptionsBase<T> {
    protected TSettings settings;

    public AbstractPersistentSubscriptionSettingsBuilder(TSettings settings) {
        this.settings = settings;
    }

    @Deprecated
    public T enableLinkResolution() {
        return this.resolveLinks(true);
    }

    @Deprecated
    public T disableLinkResolution() {
        return this.resolveLinks(false);
    }

    @Deprecated
    public T resolveLinks(boolean value) {
        return this.resolveLinkTos(value);
    }

    public T resolveLinkTos(boolean value) {
        ((PersistentSubscriptionSettings)this.settings).setResolveLinkTos(value);
        return (T)this;
    }

    public T resolveLinkTos() {
        return this.resolveLinkTos(true);
    }

    public T notResolveLinkTos() {
        return this.resolveLinkTos(false);
    }

    public T enableExtraStatistics() {
        return this.extraStatistics(true);
    }

    public T disableExtraStatistics() {
        return this.extraStatistics(false);
    }

    public T extraStatistics(boolean value) {
        ((PersistentSubscriptionSettings)this.settings).setExtraStatistics(value);
        return (T)this;
    }

    public T checkpointAfter(Duration value) {
        this.checkpointAfterInMs((int)value.toMillis());
        return (T)this;
    }

    public T checkpointAfterInMs(int value) {
        ((PersistentSubscriptionSettings)this.settings).setCheckpointAfter(value);
        return (T)this;
    }

    public T historyBufferSize(int value) {
        ((PersistentSubscriptionSettings)this.settings).setHistoryBufferSize(value);
        return (T)this;
    }

    public T liveBufferSize(int value) {
        ((PersistentSubscriptionSettings)this.settings).setLiveBufferSize(value);
        return (T)this;
    }

    @Deprecated
    public T maxCheckpointCount(int value) {
        return this.checkpointUpperBound(value);
    }

    public T checkpointUpperBound(int value) {
        ((PersistentSubscriptionSettings)this.settings).setCheckpointUpperBound(value);
        return (T)this;
    }

    @Deprecated
    public T minCheckpointCount(int value) {
        return this.checkpointLowerBound(value);
    }

    public T checkpointLowerBound(int value) {
        ((PersistentSubscriptionSettings)this.settings).setCheckpointLowerBound(value);
        return (T)this;
    }

    public T maxSubscriberCount(int value) {
        ((PersistentSubscriptionSettings)this.settings).setMaxSubscriberCount(value);
        return (T)this;
    }

    public T maxRetryCount(int value) {
        ((PersistentSubscriptionSettings)this.settings).setMaxRetryCount(value);
        return (T)this;
    }

    public T messageTimeout(Duration value) {
        return this.messageTimeoutInMs((int)value.toMillis());
    }

    public T messageTimeoutInMs(int value) {
        ((PersistentSubscriptionSettings)this.settings).setMessageTimeoutMs(value);
        return (T)this;
    }

    public T readBatchSize(int value) {
        ((PersistentSubscriptionSettings)this.settings).setReadBatchSize(value);
        return (T)this;
    }

    public T consumerStrategy(ConsumerStrategy strategy) {
        ((PersistentSubscriptionSettings)this.settings).setConsumerStrategyName(NamedConsumerStrategy.from(strategy));
        return (T)this;
    }

    public T namedConsumerStrategy(String value) {
        ((PersistentSubscriptionSettings)this.settings).setConsumerStrategyName(value);
        return (T)this;
    }

    public TSettings getSettings() {
        return this.settings;
    }
}

