/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.OptionsBase;
import com.eventstore.dbclient.PersistentSubscriptionSettings;
import com.eventstore.dbclient.UnsupportedFeature;
import com.eventstore.dbclient.proto.persistentsubscriptions.Persistent;
import com.eventstore.dbclient.proto.persistentsubscriptions.PersistentSubscriptionsGrpc;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractUpdatePersistentSubscription {
    private final GrpcClient connection;
    private final String group;
    private final PersistentSubscriptionSettings settings;
    private final OptionsBase options;

    public AbstractUpdatePersistentSubscription(GrpcClient connection, String group, PersistentSubscriptionSettings settings, OptionsBase options) {
        this.connection = connection;
        this.group = group;
        this.settings = settings;
        this.options = options;
    }

    protected Persistent.UpdateReq.Settings.Builder createSettings() {
        return Persistent.UpdateReq.Settings.newBuilder();
    }

    protected abstract Persistent.UpdateReq.Options.Builder createOptions();

    public CompletableFuture execute() {
        return this.connection.runWithArgs(args -> {
            CompletableFuture result = new CompletableFuture();
            PersistentSubscriptionsGrpc.PersistentSubscriptionsStub client = GrpcUtils.configureStub(PersistentSubscriptionsGrpc.newStub((Channel)args.getChannel()), this.connection.getSettings(), this.options);
            Persistent.UpdateReq.Settings.Builder settingsBuilder = this.createSettings();
            settingsBuilder.setResolveLinks(this.settings.shouldResolveLinkTos()).setReadBatchSize(this.settings.getReadBatchSize()).setMinCheckpointCount(this.settings.getCheckpointLowerBound()).setMaxCheckpointCount(this.settings.getCheckpointUpperBound()).setMessageTimeoutMs(this.settings.getMessageTimeoutMs()).setMaxSubscriberCount(this.settings.getMaxSubscriberCount()).setMaxRetryCount(this.settings.getMaxRetryCount()).setLiveBufferSize(this.settings.getLiveBufferSize()).setHistoryBufferSize(this.settings.getHistoryBufferSize()).setExtraStatistics(this.settings.isExtraStatistics()).setCheckpointAfterMs(this.settings.getCheckpointAfterInMs());
            switch (this.settings.getConsumerStrategyName()) {
                case "DispatchToSingle": {
                    settingsBuilder.setNamedConsumerStrategy(Persistent.UpdateReq.ConsumerStrategy.DispatchToSingle);
                    break;
                }
                case "RoundRobin": {
                    settingsBuilder.setNamedConsumerStrategy(Persistent.UpdateReq.ConsumerStrategy.RoundRobin);
                    break;
                }
                case "Pinned": {
                    settingsBuilder.setNamedConsumerStrategy(Persistent.UpdateReq.ConsumerStrategy.Pinned);
                }
            }
            Persistent.UpdateReq req = Persistent.UpdateReq.newBuilder().setOptions(this.createOptions().setSettings(settingsBuilder).setGroupName(this.group)).build();
            if (req.getOptions().hasAll() && !args.supportFeature(32)) {
                result.completeExceptionally(new UnsupportedFeature());
            } else {
                client.update(req, (StreamObserver<Persistent.UpdateResp>)GrpcUtils.convertSingleResponse(result));
            }
            return result;
        });
    }
}

