/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConnectionMetadata;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.NodePreference;
import com.eventstore.dbclient.NotLeaderException;
import com.eventstore.dbclient.OperationKind;
import com.eventstore.dbclient.OptionsBase;
import com.eventstore.dbclient.StreamRevision;
import com.eventstore.dbclient.ThrowingFunction;
import com.eventstore.dbclient.UserCredentials;
import com.eventstore.dbclient.proto.shared.Shared;
import com.eventstore.dbclient.proto.streams.StreamsOuterClass;
import com.google.protobuf.ByteString;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractAsyncStub;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.MetadataUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public final class GrpcUtils {
    public static <ReqT, RespT> ClientResponseObserver<ReqT, RespT> convertSingleResponse(CompletableFuture<RespT> dest) {
        return GrpcUtils.convertSingleResponse(dest, x -> x);
    }

    public static <ReqT, RespT, TargetT, ExceptionT extends Throwable> ClientResponseObserver<ReqT, RespT> convertSingleResponse(final CompletableFuture<TargetT> dest, final ThrowingFunction<RespT, TargetT, ExceptionT> converter) {
        return new ClientResponseObserver<ReqT, RespT>(){

            public void beforeStart(ClientCallStreamObserver<ReqT> requestStream) {
            }

            public void onNext(RespT value) {
                try {
                    Object converted = converter.apply(value);
                    dest.complete(converted);
                }
                catch (Throwable e) {
                    dest.completeExceptionally(e);
                }
            }

            public void onError(Throwable t) {
                if (t instanceof StatusRuntimeException) {
                    StatusRuntimeException e = (StatusRuntimeException)t;
                    String leaderHost = (String)e.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-host", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                    String leaderPort = (String)e.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-port", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                    if (leaderHost != null && leaderPort != null) {
                        NotLeaderException reason = new NotLeaderException(leaderHost, Integer.valueOf(leaderPort));
                        dest.completeExceptionally(reason);
                        return;
                    }
                }
                dest.completeExceptionally(t);
            }

            public void onCompleted() {
            }
        };
    }

    public static StreamsOuterClass.ReadReq.Options.StreamOptions toStreamOptions(String streamName, StreamRevision revision) {
        StreamsOuterClass.ReadReq.Options.StreamOptions.Builder builder = StreamsOuterClass.ReadReq.Options.StreamOptions.newBuilder().setStreamIdentifier(Shared.StreamIdentifier.newBuilder().setStreamName(ByteString.copyFromUtf8((String)streamName)).build());
        if (revision == StreamRevision.END) {
            return builder.setEnd(Shared.Empty.getDefaultInstance()).build();
        }
        if (revision == StreamRevision.START) {
            return builder.setStart(Shared.Empty.getDefaultInstance()).build();
        }
        return builder.setRevision(revision.getValueUnsigned()).build();
    }

    public static <S extends AbstractAsyncStub<S>, O> S configureStub(S stub, EventStoreDBClientSettings settings, OptionsBase<O> options) {
        Object finalStub = stub;
        ConnectionMetadata metadata = new ConnectionMetadata();
        if (options.getKind() != OperationKind.Streaming) {
            long deadlineInMs = 10000L;
            if (options.getDeadline() != null) {
                deadlineInMs = options.getDeadline();
            } else if (settings.getDefaultDeadline() != null) {
                deadlineInMs = settings.getDefaultDeadline();
            }
            finalStub = (AbstractAsyncStub)finalStub.withDeadlineAfter(deadlineInMs, TimeUnit.MILLISECONDS);
        }
        UserCredentials credentials = null;
        if (options.hasUserCredentials()) {
            credentials = options.getCredentials();
        } else if (settings.getDefaultCredentials() != null) {
            credentials = settings.getDefaultCredentials().toUserCredentials();
        }
        if (credentials != null) {
            metadata.authenticated(credentials);
        }
        if (options.isLeaderRequired() || settings.getNodePreference() == NodePreference.LEADER) {
            metadata.requiresLeader();
        }
        return (S)((AbstractAsyncStub)finalStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata.build())}));
    }
}

