/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConsumerStrategy;
import com.eventstore.dbclient.PersistentSubscriptionToAllSettings;
import com.eventstore.dbclient.PersistentSubscriptionToStreamSettings;
import com.eventstore.dbclient.StreamPosition;
import java.time.Duration;

public abstract class PersistentSubscriptionSettings {
    private int checkpointAfter;
    private boolean extraStatistics;
    private boolean resolveLinkTos;
    private int historyBufferSize;
    private int liveBufferSize;
    private int checkpointUpperBound;
    private int maxRetryCount;
    private int maxSubscriberCount;
    private int messageTimeoutMs;
    private int checkpointLowerBound;
    private int readBatchSize;
    private String consumerStrategyName;

    public PersistentSubscriptionSettings() {
    }

    public static PersistentSubscriptionToStreamSettings defaultRegular() {
        PersistentSubscriptionToStreamSettings settings = new PersistentSubscriptionToStreamSettings();
        PersistentSubscriptionSettings.defaultCommon(settings);
        settings.setStartFrom(StreamPosition.end());
        return settings;
    }

    public static PersistentSubscriptionToAllSettings defaultToAll() {
        PersistentSubscriptionToAllSettings settings = new PersistentSubscriptionToAllSettings();
        PersistentSubscriptionSettings.defaultCommon(settings);
        settings.setStartFrom(StreamPosition.end());
        return settings;
    }

    private static <A extends PersistentSubscriptionSettings> void defaultCommon(A settings) {
        settings.setMessageTimeoutMs(30000);
        settings.setMaxRetryCount(10);
        settings.setLiveBufferSize(500);
        settings.setReadBatchSize(20);
        settings.setHistoryBufferSize(500);
        settings.setCheckpointAfter(2000);
        settings.setCheckpointLowerBound(10);
        settings.setCheckpointUpperBound(1000);
        settings.setMaxSubscriberCount(0);
        settings.setConsumerStrategyName("RoundRobin");
    }

    public PersistentSubscriptionSettings(int checkpointAfter, boolean extraStatistics, boolean resolveLinks, int historyBufferSize, int liveBufferSize, int checkpointUpperBound, int maxRetryCount, int maxSubscriberCount, int messageTimeoutMs, int minCheckpointCount, int readBatchSize, String consumerStrategyName) {
        this.checkpointAfter = checkpointAfter;
        this.extraStatistics = extraStatistics;
        this.resolveLinkTos = resolveLinks;
        this.historyBufferSize = historyBufferSize;
        this.liveBufferSize = liveBufferSize;
        this.checkpointUpperBound = checkpointUpperBound;
        this.maxRetryCount = maxRetryCount;
        this.maxSubscriberCount = maxSubscriberCount;
        this.messageTimeoutMs = messageTimeoutMs;
        this.checkpointLowerBound = minCheckpointCount;
        this.readBatchSize = readBatchSize;
        this.consumerStrategyName = consumerStrategyName;
    }

    public int getCheckpointAfterInMs() {
        return this.checkpointAfter;
    }

    public Duration getCheckpointAfter() {
        return Duration.ofMillis(this.checkpointAfter);
    }

    public boolean isExtraStatistics() {
        return this.extraStatistics;
    }

    public boolean isResolveLinks() {
        return this.shouldResolveLinkTos();
    }

    public boolean shouldResolveLinkTos() {
        return this.resolveLinkTos;
    }

    public int getHistoryBufferSize() {
        return this.historyBufferSize;
    }

    public int getLiveBufferSize() {
        return this.liveBufferSize;
    }

    @Deprecated
    public long getMaxCheckpointCount() {
        return this.getCheckpointUpperBound();
    }

    public int getCheckpointUpperBound() {
        return this.checkpointUpperBound;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public int getMaxSubscriberCount() {
        return this.maxSubscriberCount;
    }

    public Duration getMessageTimeout() {
        return Duration.ofMillis(this.messageTimeoutMs);
    }

    public int getMessageTimeoutMs() {
        return this.messageTimeoutMs;
    }

    @Deprecated
    public long getMinCheckpointCount() {
        return this.getCheckpointLowerBound();
    }

    public int getCheckpointLowerBound() {
        return this.checkpointLowerBound;
    }

    public int getReadBatchSize() {
        return this.readBatchSize;
    }

    @Deprecated
    public ConsumerStrategy getStrategy() throws Exception {
        switch (this.consumerStrategyName) {
            case "DispatchToSingle": {
                return ConsumerStrategy.DispatchToSingle;
            }
            case "RoundRobin": {
                return ConsumerStrategy.RoundRobin;
            }
            case "Pinned": {
                return ConsumerStrategy.Pinned;
            }
        }
        throw new Exception("Non-default ConsumerStrategy specified, use getConsumerStrategyName()");
    }

    public String getConsumerStrategyName() {
        return this.consumerStrategyName;
    }

    public void setCheckpointAfter(int checkpointAfter) {
        this.checkpointAfter = checkpointAfter;
    }

    public void setExtraStatistics(boolean extraStatistics) {
        this.extraStatistics = extraStatistics;
    }

    public boolean isResolveLinkTos() {
        return this.resolveLinkTos;
    }

    public void setResolveLinkTos(boolean resolveLinkTos) {
        this.resolveLinkTos = resolveLinkTos;
    }

    public void setHistoryBufferSize(int historyBufferSize) {
        this.historyBufferSize = historyBufferSize;
    }

    public void setLiveBufferSize(int liveBufferSize) {
        this.liveBufferSize = liveBufferSize;
    }

    public void setCheckpointUpperBound(int checkpointUpperBound) {
        this.checkpointUpperBound = checkpointUpperBound;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public void setMaxSubscriberCount(int maxSubscriberCount) {
        this.maxSubscriberCount = maxSubscriberCount;
    }

    public void setMessageTimeoutMs(int messageTimeoutMs) {
        this.messageTimeoutMs = messageTimeoutMs;
    }

    public void setCheckpointLowerBound(int checkpointLowerBound) {
        this.checkpointLowerBound = checkpointLowerBound;
    }

    public void setReadBatchSize(int readBatchSize) {
        this.readBatchSize = readBatchSize;
    }

    public void setConsumerStrategyName(String consumerStrategyName) {
        this.consumerStrategyName = consumerStrategyName;
    }
}

