/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.OptionsBase;
import com.eventstore.dbclient.PersistentSubscriptionSettings;
import com.eventstore.dbclient.UnsupportedFeatureException;
import com.eventstore.dbclient.proto.persistentsubscriptions.Persistent;
import com.eventstore.dbclient.proto.persistentsubscriptions.PersistentSubscriptionsGrpc;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCreatePersistentSubscription<TPos, TSettings extends PersistentSubscriptionSettings> {
    private final GrpcClient client;
    private final String group;
    private final TSettings settings;
    private final OptionsBase options;
    private static final Logger logger = LoggerFactory.getLogger(AbstractCreatePersistentSubscription.class);

    public AbstractCreatePersistentSubscription(GrpcClient client, String group, TSettings settings, OptionsBase options) {
        this.client = client;
        this.group = group;
        this.settings = settings;
        this.options = options;
    }

    protected Persistent.CreateReq.Settings.Builder createSettings() {
        return Persistent.CreateReq.Settings.newBuilder();
    }

    protected abstract Persistent.CreateReq.Options.Builder createOptions();

    public CompletableFuture execute() {
        return this.client.runWithArgs(args -> {
            CompletableFuture result = new CompletableFuture();
            PersistentSubscriptionsGrpc.PersistentSubscriptionsStub client = GrpcUtils.configureStub(PersistentSubscriptionsGrpc.newStub((Channel)args.getChannel()), this.client.getSettings(), this.options);
            Persistent.CreateReq.Settings.Builder settingsBuilder = this.createSettings();
            settingsBuilder.setResolveLinks(((PersistentSubscriptionSettings)this.settings).shouldResolveLinkTos()).setReadBatchSize(((PersistentSubscriptionSettings)this.settings).getReadBatchSize()).setMinCheckpointCount(((PersistentSubscriptionSettings)this.settings).getCheckpointLowerBound()).setMaxCheckpointCount(((PersistentSubscriptionSettings)this.settings).getCheckpointUpperBound()).setMessageTimeoutMs(((PersistentSubscriptionSettings)this.settings).getMessageTimeoutMs()).setMaxSubscriberCount(((PersistentSubscriptionSettings)this.settings).getMaxSubscriberCount()).setMaxRetryCount(((PersistentSubscriptionSettings)this.settings).getMaxRetryCount()).setLiveBufferSize(((PersistentSubscriptionSettings)this.settings).getLiveBufferSize()).setHistoryBufferSize(((PersistentSubscriptionSettings)this.settings).getHistoryBufferSize()).setExtraStatistics(((PersistentSubscriptionSettings)this.settings).isExtraStatistics()).setCheckpointAfterMs(((PersistentSubscriptionSettings)this.settings).getCheckpointAfterInMs());
            if (((PersistentSubscriptionSettings)this.settings).getNamedConsumerStrategy().isDispatchToSingle()) {
                settingsBuilder.setNamedConsumerStrategy(Persistent.CreateReq.ConsumerStrategy.DispatchToSingle);
            } else if (((PersistentSubscriptionSettings)this.settings).getNamedConsumerStrategy().isRoundRobin()) {
                settingsBuilder.setNamedConsumerStrategy(Persistent.CreateReq.ConsumerStrategy.RoundRobin);
            } else if (((PersistentSubscriptionSettings)this.settings).getNamedConsumerStrategy().isPinned()) {
                settingsBuilder.setNamedConsumerStrategy(Persistent.CreateReq.ConsumerStrategy.Pinned);
            } else {
                logger.error(String.format("Unsupported named consumer strategy: '%s'", ((PersistentSubscriptionSettings)this.settings).getNamedConsumerStrategy().toString()));
                throw new UnsupportedFeatureException();
            }
            Persistent.CreateReq req = Persistent.CreateReq.newBuilder().setOptions(this.createOptions().setSettings(settingsBuilder).setGroupName(this.group)).build();
            if (req.getOptions().hasAll() && !args.supportFeature(32)) {
                result.completeExceptionally(new UnsupportedFeatureException());
            } else {
                client.create(req, (StreamObserver<Persistent.CreateResp>)GrpcUtils.convertSingleResponse(result));
            }
            return result;
        });
    }
}

