/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.AppendToStream;
import com.eventstore.dbclient.AppendToStreamOptions;
import com.eventstore.dbclient.DeleteResult;
import com.eventstore.dbclient.DeleteStream;
import com.eventstore.dbclient.DeleteStreamOptions;
import com.eventstore.dbclient.EventData;
import com.eventstore.dbclient.EventDataBuilder;
import com.eventstore.dbclient.EventStoreDBClientBase;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.Position;
import com.eventstore.dbclient.ReadAll;
import com.eventstore.dbclient.ReadAllOptions;
import com.eventstore.dbclient.ReadMessage;
import com.eventstore.dbclient.ReadResult;
import com.eventstore.dbclient.ReadStream;
import com.eventstore.dbclient.ReadStreamOptions;
import com.eventstore.dbclient.ReadSubscriber;
import com.eventstore.dbclient.RecordedEvent;
import com.eventstore.dbclient.StreamMetadata;
import com.eventstore.dbclient.StreamNotFoundException;
import com.eventstore.dbclient.SubscribeToAll;
import com.eventstore.dbclient.SubscribeToAllOptions;
import com.eventstore.dbclient.SubscribeToStream;
import com.eventstore.dbclient.SubscribeToStreamOptions;
import com.eventstore.dbclient.Subscription;
import com.eventstore.dbclient.SubscriptionListener;
import com.eventstore.dbclient.WriteResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class EventStoreDBClient
extends EventStoreDBClientBase {
    private EventStoreDBClient(EventStoreDBClientSettings settings) {
        super(settings);
    }

    public static EventStoreDBClient create(EventStoreDBClientSettings settings) {
        return new EventStoreDBClient(settings);
    }

    public CompletableFuture<WriteResult> appendToStream(String streamName, EventData ... events) {
        return this.appendToStream(streamName, Arrays.stream(events).iterator());
    }

    public CompletableFuture<WriteResult> appendToStream(String streamName, Iterator<EventData> events) {
        return this.appendToStream(streamName, AppendToStreamOptions.get(), events);
    }

    public CompletableFuture<WriteResult> appendToStream(String streamName, AppendToStreamOptions options, EventData ... events) {
        return this.appendToStream(streamName, options, Arrays.stream(events).iterator());
    }

    public CompletableFuture<WriteResult> appendToStream(String streamName, AppendToStreamOptions options, Iterator<EventData> events) {
        if (options == null) {
            options = AppendToStreamOptions.get();
        }
        return new AppendToStream(this.getGrpcClient(), streamName, events, options).execute();
    }

    public CompletableFuture<WriteResult> setStreamMetadata(String streamName, StreamMetadata metadata) {
        return this.setStreamMetadata(streamName, null, metadata);
    }

    public CompletableFuture<WriteResult> setStreamMetadata(String streamName, AppendToStreamOptions options, StreamMetadata metadata) {
        EventData event = EventDataBuilder.json("$metadata", metadata.serialize()).build();
        return this.appendToStream("$$" + streamName, options, event);
    }

    public CompletableFuture<ReadResult> readStream(String streamName, ReadStreamOptions options) {
        return EventStoreDBClient.readEventsFromPublisher(this.readStreamReactive(streamName, options));
    }

    public Publisher<ReadMessage> readStreamReactive(String streamName) {
        return this.readStreamReactive(streamName, ReadStreamOptions.get());
    }

    public Publisher<ReadMessage> readStreamReactive(String streamName, ReadStreamOptions options) {
        if (options == null) {
            options = ReadStreamOptions.get();
        }
        return new ReadStream(this.getGrpcClient(), streamName, options);
    }

    private static <A, B> Publisher<B> publisherMap(Publisher<A> parent, final Function<A, B> fun) {
        return sub -> parent.subscribe(new Subscriber<A>(){

            public void onSubscribe(org.reactivestreams.Subscription s) {
                sub.onSubscribe(s);
            }

            public void onNext(A a) {
                sub.onNext(fun.apply(a));
            }

            public void onError(Throwable t) {
                sub.onError(t);
            }

            public void onComplete() {
                sub.onComplete();
            }
        });
    }

    public CompletableFuture<StreamMetadata> getStreamMetadata(String streamName) {
        return this.getStreamMetadata(streamName, null);
    }

    public CompletableFuture<StreamMetadata> getStreamMetadata(String streamName, ReadStreamOptions options) {
        return ((CompletableFuture)this.readStream("$$" + streamName, options).thenCompose(result -> {
            RecordedEvent event = result.getEvents().get(0).getOriginalEvent();
            CompletableFuture<StreamMetadata> out = new CompletableFuture<StreamMetadata>();
            try {
                HashMap source = event.getEventDataAs(HashMap.class);
                out.complete(StreamMetadata.deserialize(source));
            }
            catch (Throwable e) {
                out.completeExceptionally(e);
            }
            return out;
        })).exceptionally(e -> {
            if (e.getCause() instanceof StreamNotFoundException) {
                return new StreamMetadata();
            }
            throw new RuntimeException((Throwable)e);
        });
    }

    public CompletableFuture<ReadResult> readAll() {
        return this.readAll(ReadAllOptions.get());
    }

    public CompletableFuture<ReadResult> readAll(ReadAllOptions options) {
        return EventStoreDBClient.readEventsFromPublisher(this.readAllReactive(options));
    }

    public Publisher<ReadMessage> readAllReactive() {
        return this.readAllReactive(ReadAllOptions.get());
    }

    public Publisher<ReadMessage> readAllReactive(ReadAllOptions options) {
        if (options == null) {
            options = ReadAllOptions.get();
        }
        return new ReadAll(this.getGrpcClient(), options);
    }

    public CompletableFuture<Subscription> subscribeToStream(String streamName, SubscriptionListener listener) {
        return this.subscribeToStream(streamName, listener, SubscribeToStreamOptions.get());
    }

    public CompletableFuture<Subscription> subscribeToStream(String streamName, SubscriptionListener listener, SubscribeToStreamOptions options) {
        if (options == null) {
            options = SubscribeToStreamOptions.get();
        }
        return new SubscribeToStream(this.getGrpcClient(), streamName, listener, options).execute();
    }

    public CompletableFuture<Subscription> subscribeToAll(SubscriptionListener listener) {
        return this.subscribeToAll(listener, SubscribeToAllOptions.get());
    }

    public CompletableFuture<Subscription> subscribeToAll(SubscriptionListener listener, SubscribeToAllOptions options) {
        if (options == null) {
            options = SubscribeToAllOptions.get();
        }
        return new SubscribeToAll(this.getGrpcClient(), listener, options).execute();
    }

    public CompletableFuture<DeleteResult> deleteStream(String streamName) {
        return this.deleteStream(streamName, DeleteStreamOptions.get());
    }

    public CompletableFuture<DeleteResult> deleteStream(String streamName, DeleteStreamOptions options) {
        if (options == null) {
            options = DeleteStreamOptions.get();
        }
        return new DeleteStream(this.getGrpcClient(), streamName, true, options).execute();
    }

    public CompletableFuture<DeleteResult> tombstoneStream(String streamName) {
        return this.deleteStream(streamName, DeleteStreamOptions.get());
    }

    public CompletableFuture<DeleteResult> tombstoneStream(String streamName, DeleteStreamOptions options) {
        if (options == null) {
            options = DeleteStreamOptions.get();
        }
        return new DeleteStream(this.getGrpcClient(), streamName, false, options).execute();
    }

    private static CompletableFuture<ReadResult> readEventsFromPublisher(Publisher<ReadMessage> eventPublisher) {
        final CompletableFuture<ReadResult> future = new CompletableFuture<ReadResult>();
        final LinkedList events = new LinkedList();
        eventPublisher.subscribe((Subscriber)new ReadSubscriber(){
            long firstStreamPosition = 0L;
            long lastStreamPosition = 0L;
            Position lastAllStreamPosition = null;

            @Override
            public void onEvent(ReadMessage e) {
                if (e.hasFirstStreamPosition()) {
                    this.firstStreamPosition = e.getFirstStreamPosition();
                    return;
                }
                if (e.hasLastStreamPosition()) {
                    this.lastStreamPosition = e.getLastStreamPosition();
                    return;
                }
                if (e.hasLastAllPosition()) {
                    this.lastAllStreamPosition = e.getLastAllPosition();
                    return;
                }
                if (e.hasEvent()) {
                    events.add(e.getEvent());
                }
            }

            public void onError(Throwable t) {
                future.completeExceptionally(t);
            }

            public void onComplete() {
                future.complete(new ReadResult(events, this.firstStreamPosition, this.lastStreamPosition, this.lastAllStreamPosition));
            }
        });
        return future;
    }
}

