/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ClusterInfo;
import com.eventstore.dbclient.NodePreference;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;

class NodeSelector {
    private static final Random random = new Random();
    private static final Set<ClusterInfo.MemberState> invalidStates = new HashSet<ClusterInfo.MemberState>(){
        {
            this.add(ClusterInfo.MemberState.MANAGER);
            this.add(ClusterInfo.MemberState.SHUTTING_DOWN);
            this.add(ClusterInfo.MemberState.SHUT_DOWN);
            this.add(ClusterInfo.MemberState.UNKNOWN);
            this.add(ClusterInfo.MemberState.INITIALIZING);
            this.add(ClusterInfo.MemberState.RESIGNING_LEADER);
            this.add(ClusterInfo.MemberState.PRE_LEADER);
            this.add(ClusterInfo.MemberState.PRE_REPLICA);
            this.add(ClusterInfo.MemberState.PRE_READ_ONLY_REPLICA);
            this.add(ClusterInfo.MemberState.CLONE);
            this.add(ClusterInfo.MemberState.DISCOVER_LEADER);
        }
    };
    private static final Map<NodePreference, Comparator<ClusterInfo.Member>> memberComparators = new HashMap<NodePreference, Comparator<ClusterInfo.Member>>(){
        {
            this.put(NodePreference.LEADER, new MemberComparator(ClusterInfo.MemberState.LEADER));
            this.put(NodePreference.FOLLOWER, new MemberComparator(ClusterInfo.MemberState.FOLLOWER));
            this.put(NodePreference.READ_ONLY_REPLICA, new MemberComparator(ClusterInfo.MemberState.READ_ONLY_REPLICA));
            this.put(NodePreference.RANDOM, (o1, o2) -> random.nextBoolean() ? -1 : 1);
        }
    };
    private final Comparator<ClusterInfo.Member> memberComparator;

    NodeSelector(NodePreference nodePreference) {
        this.memberComparator = memberComparators.get((Object)nodePreference);
    }

    Optional<ClusterInfo.Member> determineBestFitNode(ClusterInfo clusterInfo) {
        return clusterInfo.getMembers().stream().filter(ClusterInfo.Member::isAlive).filter(m -> !invalidStates.contains((Object)m.getState())).sorted(this.memberComparator).findFirst();
    }

    private static class MemberComparator
    implements Comparator<ClusterInfo.Member> {
        private final ClusterInfo.MemberState preferredState;

        private MemberComparator(ClusterInfo.MemberState preferredState) {
            this.preferredState = preferredState;
        }

        @Override
        public int compare(ClusterInfo.Member o1, ClusterInfo.Member o2) {
            if (o1.getState().equals((Object)this.preferredState) && o2.getState().equals((Object)this.preferredState)) {
                return random.nextBoolean() ? -1 : 0;
            }
            if (o1.getState().equals((Object)this.preferredState) && !o2.getState().equals((Object)this.preferredState)) {
                return -1;
            }
            return 1;
        }
    }
}

