/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConnectionMetadata;
import com.eventstore.dbclient.OperationKind;
import com.eventstore.dbclient.UserCredentials;
import io.grpc.Metadata;

class OptionsBase<T> {
    private final ConnectionMetadata metadata = new ConnectionMetadata();
    private Long deadline;
    private final OperationKind kind;
    private UserCredentials credentials;
    private boolean requiresLeader;

    protected OptionsBase() {
        this(OperationKind.Regular);
    }

    protected OptionsBase(OperationKind kind) {
        this.kind = kind;
    }

    Metadata getMetadata() {
        return this.metadata.build();
    }

    boolean hasUserCredentials() {
        return this.metadata.hasUserCredentials();
    }

    String getUserCredentials() {
        return this.metadata.getUserCredentials();
    }

    public T authenticated(UserCredentials credentials) {
        this.credentials = credentials;
        return (T)this;
    }

    public T authenticated(String login, String password) {
        return this.authenticated(new UserCredentials(login, password));
    }

    public T requiresLeader() {
        return this.requiresLeader(true);
    }

    public T notRequireLeader() {
        return this.requiresLeader(false);
    }

    public T requiresLeader(boolean value) {
        this.requiresLeader = value;
        return (T)this;
    }

    public T deadline(long durationInMs) {
        this.deadline = durationInMs;
        return (T)this;
    }

    Long getDeadline() {
        return this.deadline;
    }

    OperationKind getKind() {
        return this.kind;
    }

    boolean isLeaderRequired() {
        return this.requiresLeader;
    }

    UserCredentials getCredentials() {
        return this.credentials;
    }
}

