/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.EventStoreDBClientSettings;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionState {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionState.class);
    private static final int MAX_INBOUND_MESSAGE_LENGTH = 0x1100000;
    private final EventStoreDBClientSettings settings;
    private final SslContext sslContext;
    private InetSocketAddress previous;
    private ManagedChannel currentChannel;
    private boolean confirmedChannel;

    ConnectionState(EventStoreDBClientSettings settings) {
        this.settings = settings;
        if (settings.isTls()) {
            try {
                SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
                if (settings.getTlsCaFile() != null) {
                    sslContextBuilder.trustManager(new File(settings.getTlsCaFile()));
                }
                if (!settings.isTlsVerifyCert()) {
                    sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                }
                this.sslContext = sslContextBuilder.build();
            }
            catch (SSLException e) {
                logger.error("Exception when creating SSL context", (Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            this.sslContext = null;
        }
    }

    InetSocketAddress getLastConnectedEndpoint() {
        return this.confirmedChannel ? this.previous : null;
    }

    void confirmChannel() {
        this.confirmedChannel = true;
    }

    ManagedChannel getCurrentChannel() {
        return this.currentChannel;
    }

    EventStoreDBClientSettings getSettings() {
        return this.settings;
    }

    void connect(InetSocketAddress addr) {
        this.closeChannel();
        NettyChannelBuilder builder = (NettyChannelBuilder)NettyChannelBuilder.forAddress((SocketAddress)addr).maxInboundMessageSize(0x1100000).intercept(this.settings.getInterceptors());
        if (this.sslContext == null) {
            builder.usePlaintext();
        } else {
            builder.sslContext(this.sslContext);
        }
        if (this.settings.getKeepAliveTimeout() <= 0L) {
            builder.keepAliveTimeout(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        } else {
            builder.keepAliveTimeout(this.settings.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
        }
        if (this.settings.getKeepAliveInterval() <= 0L) {
            builder.keepAliveTime(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        } else {
            builder.keepAliveTime(this.settings.getKeepAliveInterval(), TimeUnit.MILLISECONDS);
        }
        this.currentChannel = builder.build();
        this.confirmedChannel = false;
        this.previous = addr;
    }

    private void closeChannel() {
        if (this.currentChannel != null) {
            try {
                logger.trace("Shutting down existing gRPC channel [{}]", (Object)this.currentChannel);
                boolean terminated = this.currentChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
                if (!terminated) {
                    this.currentChannel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
                }
                logger.trace("Successful shutdown of gRPC channel [{}]", (Object)this.currentChannel);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.currentChannel = null;
            }
        }
    }

    public void shutdown() {
        this.closeChannel();
    }

    public void clear() {
        this.previous = null;
        this.confirmedChannel = false;
    }
}

