/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.EventData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.UUID;

public class EventDataBuilder {
    private byte[] eventData;
    private byte[] metadata;
    private String eventType;
    private boolean isJson;
    private UUID id;

    EventDataBuilder() {
    }

    public static <A> EventDataBuilder json(String eventType, A eventData) {
        return EventDataBuilder.json(null, eventType, eventData);
    }

    @Deprecated
    public static <A> EventDataBuilder json(UUID id, String eventType, A eventData) {
        try {
            JsonMapper mapper = new JsonMapper();
            return EventDataBuilder.json(id, eventType, mapper.writeValueAsBytes(eventData));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static EventDataBuilder json(String eventType, byte[] eventData) {
        return EventDataBuilder.json(null, eventType, eventData);
    }

    public static EventDataBuilder json(UUID id, String eventType, byte[] eventData) {
        return EventDataBuilder.binary(id, eventType, eventData, true);
    }

    public static EventDataBuilder binary(String eventType, byte[] eventData) {
        return EventDataBuilder.binary(null, eventType, eventData);
    }

    public static EventDataBuilder binary(UUID id, String eventType, byte[] eventData) {
        return EventDataBuilder.binary(id, eventType, eventData, false);
    }

    public static EventDataBuilder binary(UUID id, String eventType, byte[] eventData, boolean isJson) {
        EventDataBuilder self = new EventDataBuilder();
        self.eventData = eventData;
        self.eventType = eventType;
        self.isJson = isJson;
        self.id = id;
        return self;
    }

    public EventDataBuilder eventId(UUID id) {
        this.id = id;
        return this;
    }

    @Deprecated
    public <A> EventDataBuilder metadataAsJson(A value) {
        try {
            JsonMapper mapper = new JsonMapper();
            this.metadata = mapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public EventDataBuilder metadataAsBytes(byte[] value) {
        this.metadata = value;
        return this;
    }

    public EventData build() {
        UUID eventId = this.id == null ? UUID.randomUUID() : this.id;
        String contentType = this.isJson ? "application/json" : "application/octet-stream";
        return new EventData(eventId, this.eventType, contentType, this.eventData, this.metadata);
    }
}

