/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ClusterInfo;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.OptionsBase;
import com.eventstore.dbclient.proto.gossip.GossipGrpc;
import com.eventstore.dbclient.proto.gossip.GossipOuterClass;
import com.eventstore.dbclient.proto.shared.Shared;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

class GossipClient {
    private final ManagedChannel _channel;
    private final GossipGrpc.GossipStub _stub;

    public GossipClient(EventStoreDBClientSettings settings, ManagedChannel channel) {
        this._channel = channel;
        this._stub = GrpcUtils.configureStub(GossipGrpc.newStub((Channel)this._channel), settings, new GossipOption(), Long.valueOf(settings.getGossipTimeout()));
    }

    public void shutdown() {
        try {
            this._channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public CompletableFuture<ClusterInfo> read() {
        CompletableFuture<ClusterInfo> result = new CompletableFuture<ClusterInfo>();
        this._stub.read(Shared.Empty.getDefaultInstance(), (StreamObserver<GossipOuterClass.ClusterInfo>)this.convertSingleResponse(result, resp -> {
            ArrayList<ClusterInfo.Member> members = new ArrayList<ClusterInfo.Member>();
            for (GossipOuterClass.MemberInfo info : resp.getMembersList()) {
                UUID instanceId = null;
                if (info.hasInstanceId()) {
                    instanceId = info.getInstanceId().hasStructured() ? new UUID(info.getInstanceId().getStructured().getMostSignificantBits(), info.getInstanceId().getStructured().getLeastSignificantBits()) : UUID.fromString(info.getInstanceId().getString());
                }
                ClusterInfo.MemberState state = ClusterInfo.MemberState.fromWire(info.getState());
                InetSocketAddress endpoint = new InetSocketAddress(info.getHttpEndPoint().getAddress(), info.getHttpEndPoint().getPort());
                ClusterInfo.Member member = new ClusterInfo.Member(instanceId, info.getIsAlive(), state, endpoint);
                members.add(member);
            }
            return new ClusterInfo(members);
        }));
        return result;
    }

    private <ReqT, RespT, TargetT> ClientResponseObserver<ReqT, RespT> convertSingleResponse(final CompletableFuture<TargetT> dest, final Function<RespT, TargetT> converter) {
        return new ClientResponseObserver<ReqT, RespT>(){

            public void beforeStart(ClientCallStreamObserver<ReqT> requestStream) {
            }

            public void onNext(RespT value) {
                try {
                    Object converted = converter.apply(value);
                    dest.complete(converted);
                }
                catch (Throwable e) {
                    dest.completeExceptionally(e);
                }
            }

            public void onError(Throwable t) {
                dest.completeExceptionally(t);
            }

            public void onCompleted() {
            }
        };
    }

    class GossipOption
    extends OptionsBase<Void> {
        GossipOption() {
        }
    }
}

