/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.Position;
import com.eventstore.dbclient.ResolvedEvent;
import com.eventstore.dbclient.proto.streams.StreamsOuterClass;

public final class ReadMessage {
    private Long firstStreamPosition;
    private Long lastStreamPosition;
    private Position lastAllPosition;
    private ResolvedEvent event;

    ReadMessage(StreamsOuterClass.ReadResp resp) {
        if (resp.hasLastAllStreamPosition()) {
            this.lastAllPosition = new Position(resp.getLastAllStreamPosition().getCommitPosition(), resp.getLastAllStreamPosition().getPreparePosition());
            return;
        }
        if (resp.hasEvent()) {
            this.event = ResolvedEvent.fromWire(resp.getEvent());
            return;
        }
        if (resp.getLastStreamPosition() != 0L) {
            this.lastStreamPosition = resp.getLastStreamPosition();
            return;
        }
        this.firstStreamPosition = resp.getFirstStreamPosition();
    }

    public boolean hasFirstStreamPosition() {
        return this.firstStreamPosition != null;
    }

    public boolean hasLastStreamPosition() {
        return this.lastStreamPosition != null;
    }

    public boolean hasLastAllPosition() {
        return this.lastAllPosition != null;
    }

    public boolean hasEvent() {
        return this.event != null;
    }

    public long getFirstStreamPosition() {
        return this.firstStreamPosition;
    }

    public long getLastStreamPosition() {
        return this.lastStreamPosition;
    }

    public Position getLastAllPosition() {
        return this.lastAllPosition;
    }

    public ResolvedEvent getEvent() {
        return this.event;
    }
}

