/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConnectionShutdownException;
import com.eventstore.dbclient.ConnectionState;
import com.eventstore.dbclient.Discovery;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.Msg;
import com.eventstore.dbclient.RunWorkItem;
import com.eventstore.dbclient.ServerFeatures;
import com.eventstore.dbclient.ServerInfo;
import com.eventstore.dbclient.Shutdown;
import com.eventstore.dbclient.WorkItemArgs;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionService
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(ConnectionService.class);
    private final GrpcClient client;
    private final AtomicBoolean closed;
    private final LinkedBlockingQueue<Msg> queue;
    private final Discovery discovery;
    private final EventStoreDBClientSettings settings;
    private final ConnectionState connection;
    private UUID channelId = UUID.randomUUID();
    private ServerInfo serverInfo = null;

    ConnectionService(EventStoreDBClientSettings settings, Discovery discovery) {
        this.settings = settings;
        this.discovery = discovery;
        this.connection = new ConnectionState(settings);
        this.queue = new LinkedBlockingQueue();
        this.closed = new AtomicBoolean(false);
        this.client = new GrpcClient(settings, this.closed, this.queue);
    }

    GrpcClient getHandle() {
        return this.client;
    }

    @Override
    public void run() {
        try {
            while (true) {
                Msg msg = this.queue.take();
                this.logger.debug("Current msg: {}", (Object)msg);
                msg.accept(this);
            }
        }
        catch (Exception e) {
            if (!this.closed.get()) {
                this.forceExit(e);
            }
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            this.logger.error("Thread is interrupted", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean loadServerFeatures() {
        try {
            this.serverInfo = ServerFeatures.getSupportedFeatures(this.settings, this.connection.getCurrentChannel()).orElse(null);
            return true;
        }
        catch (ServerFeatures.RetryableException e) {
            this.logger.warn("An exception happened when fetching server supported features. Retrying connection attempt.", (Throwable)e);
            return false;
        }
    }

    private void drainPendingRequests() {
        this.logger.debug("Draining pending requests...");
        ArrayList msgs = new ArrayList();
        this.queue.drainTo(msgs);
        for (Msg msg : msgs) {
            msg.accept(this);
        }
        this.logger.debug("Drainage completed successfully");
    }

    private void forceExit(Exception e) {
        this.shutdown(new Shutdown(x -> {
            if (e != null) {
                this.logger.error("Unexpected error", (Throwable)e);
            }
        }));
    }

    private void forceExit() {
        this.forceExit(null);
    }

    public void createChannel(UUID previousId, InetSocketAddress candidate) {
        if (this.closed.get()) {
            this.logger.warn("Channel creation request ignored, the connection to endpoint [{}] is already closed", (Object)this.connection.getLastConnectedEndpoint());
            return;
        }
        if (!this.channelId.equals(previousId)) {
            this.logger.debug("Skipping connection attempt as new connection to endpoint [{}] has already been created.", (Object)this.connection.getLastConnectedEndpoint());
            return;
        }
        for (int attempts = 1; attempts <= this.settings.getMaxDiscoverAttempts() + 1; ++attempts) {
            if (attempts > this.settings.getMaxDiscoverAttempts()) {
                this.logger.error("Maximum discovery attempt count reached: {}", (Object)this.settings.getMaxDiscoverAttempts());
                this.forceExit();
                return;
            }
            this.logger.debug("Start connection attempt ({}/{})", (Object)attempts, (Object)this.settings.getMaxDiscoverAttempts());
            if (candidate != null) {
                this.connection.connect(candidate);
                this.logger.debug("Prepared channel to proposed leader candidate [{}]", (Object)candidate);
            } else {
                try {
                    this.discovery.run(this.connection).get();
                    if (this.loadServerFeatures()) {
                        this.channelId = UUID.randomUUID();
                        this.connection.confirmChannel();
                        this.logger.info("Connection to endpoint [{}] created successfully", (Object)this.connection.getLastConnectedEndpoint());
                        break;
                    }
                }
                catch (InterruptedException e) {
                    this.forceExit(e);
                }
                catch (ExecutionException e) {
                    this.logger.error("Error when running discovery process", (Throwable)e);
                    this.connection.clear();
                }
            }
            candidate = null;
            this.sleep(this.settings.getDiscoveryInterval());
        }
    }

    public void process(RunWorkItem args) {
        if (this.closed.get()) {
            this.logger.warn("Receive a command request but the connection to endpoint [{}] is already closed", (Object)this.connection.getLastConnectedEndpoint());
            args.getItem().accept(null, new ConnectionShutdownException());
            return;
        }
        if (this.connection.getCurrentChannel() == null) {
            this.logger.debug("Channel is not resolved yet, connecting...");
            try {
                this.createChannel(this.channelId, null);
            }
            catch (RuntimeException e) {
                args.getItem().accept(null, e);
                throw e;
            }
        }
        WorkItemArgs workArgs = new WorkItemArgs(this.channelId, this.connection.getCurrentChannel(), this.connection.getLastConnectedEndpoint(), this.serverInfo, this.queue);
        args.getItem().accept(workArgs, null);
    }

    public void shutdown(Shutdown args) {
        if (this.closed.get()) {
            args.complete();
            return;
        }
        this.logger.info("Received a shutdown request, closing connection to endpoint [{}]", (Object)this.connection.getLastConnectedEndpoint());
        this.closed.set(true);
        this.connection.shutdown();
        this.drainPendingRequests();
        this.logger.info("Connection to endpoint [{}] was closed successfully", (Object)this.connection.getLastConnectedEndpoint());
        args.complete();
        throw new ConnectionShutdownException();
    }
}

