/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.proto.shared.Shared;
import com.eventstore.dbclient.proto.streams.StreamsOuterClass;
import java.util.Objects;

public abstract class ExpectedRevision {
    public static ExpectedRevision any() {
        return new AnyExpectedRevision();
    }

    public static ExpectedRevision noStream() {
        return new NoStreamExpectedRevision();
    }

    public static ExpectedRevision streamExists() {
        return new StreamExistsExpectedRevision();
    }

    public static ExpectedRevision expectedRevision(long revision) {
        return new SpecificExpectedRevision(revision);
    }

    public static ExpectedRevision fromRawLong(long revision) {
        if (revision == -1L) {
            return ExpectedRevision.noStream();
        }
        if (revision == -2L) {
            return ExpectedRevision.any();
        }
        if (revision == -4L) {
            return ExpectedRevision.streamExists();
        }
        if (revision < 0L) {
            throw new RuntimeException(String.format("Invalid expected revision long representation '%s'", revision));
        }
        return ExpectedRevision.expectedRevision(revision);
    }

    ExpectedRevision() {
    }

    abstract StreamsOuterClass.AppendReq.Options.Builder applyOnWire(StreamsOuterClass.AppendReq.Options.Builder var1);

    abstract StreamsOuterClass.DeleteReq.Options.Builder applyOnWire(StreamsOuterClass.DeleteReq.Options.Builder var1);

    abstract StreamsOuterClass.TombstoneReq.Options.Builder applyOnWire(StreamsOuterClass.TombstoneReq.Options.Builder var1);

    public long toRawLong() {
        if (this instanceof NoStreamExpectedRevision) {
            return -1L;
        }
        if (this instanceof AnyExpectedRevision) {
            return -2L;
        }
        if (this instanceof StreamExistsExpectedRevision) {
            return -4L;
        }
        SpecificExpectedRevision revision = (SpecificExpectedRevision)this;
        return revision.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(this.getClass());
    }

    public static class AnyExpectedRevision
    extends ExpectedRevision {
        @Override
        public StreamsOuterClass.AppendReq.Options.Builder applyOnWire(StreamsOuterClass.AppendReq.Options.Builder options) {
            return options.setAny(Shared.Empty.getDefaultInstance());
        }

        @Override
        public StreamsOuterClass.DeleteReq.Options.Builder applyOnWire(StreamsOuterClass.DeleteReq.Options.Builder options) {
            return options.setAny(Shared.Empty.getDefaultInstance());
        }

        @Override
        public StreamsOuterClass.TombstoneReq.Options.Builder applyOnWire(StreamsOuterClass.TombstoneReq.Options.Builder options) {
            return options.setAny(Shared.Empty.getDefaultInstance());
        }

        public String toString() {
            return "ExpectedAny";
        }
    }

    public static class NoStreamExpectedRevision
    extends ExpectedRevision {
        @Override
        public StreamsOuterClass.AppendReq.Options.Builder applyOnWire(StreamsOuterClass.AppendReq.Options.Builder options) {
            return options.setNoStream(Shared.Empty.getDefaultInstance());
        }

        @Override
        public StreamsOuterClass.DeleteReq.Options.Builder applyOnWire(StreamsOuterClass.DeleteReq.Options.Builder options) {
            return options.setNoStream(Shared.Empty.getDefaultInstance());
        }

        @Override
        public StreamsOuterClass.TombstoneReq.Options.Builder applyOnWire(StreamsOuterClass.TombstoneReq.Options.Builder options) {
            return options.setNoStream(Shared.Empty.getDefaultInstance());
        }

        public String toString() {
            return "ExpectedNoStream";
        }
    }

    public static class StreamExistsExpectedRevision
    extends ExpectedRevision {
        @Override
        public StreamsOuterClass.AppendReq.Options.Builder applyOnWire(StreamsOuterClass.AppendReq.Options.Builder options) {
            return options.setStreamExists(Shared.Empty.getDefaultInstance());
        }

        @Override
        public StreamsOuterClass.DeleteReq.Options.Builder applyOnWire(StreamsOuterClass.DeleteReq.Options.Builder options) {
            return options.setStreamExists(Shared.Empty.getDefaultInstance());
        }

        @Override
        public StreamsOuterClass.TombstoneReq.Options.Builder applyOnWire(StreamsOuterClass.TombstoneReq.Options.Builder options) {
            return options.setStreamExists(Shared.Empty.getDefaultInstance());
        }

        public String toString() {
            return "ExpectedStreamExists";
        }
    }

    public static class SpecificExpectedRevision
    extends ExpectedRevision {
        final long version;

        SpecificExpectedRevision(long version) {
            this.version = version;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpecificExpectedRevision that = (SpecificExpectedRevision)o;
            return this.version == that.version;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.version);
        }

        @Override
        public StreamsOuterClass.AppendReq.Options.Builder applyOnWire(StreamsOuterClass.AppendReq.Options.Builder options) {
            return options.setRevision(this.version);
        }

        @Override
        public StreamsOuterClass.DeleteReq.Options.Builder applyOnWire(StreamsOuterClass.DeleteReq.Options.Builder options) {
            return options.setRevision(this.version);
        }

        @Override
        public StreamsOuterClass.TombstoneReq.Options.Builder applyOnWire(StreamsOuterClass.TombstoneReq.Options.Builder options) {
            return options.setRevision(this.version);
        }

        public String toString() {
            return Long.toString(this.version);
        }
    }
}

