/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.OperationKind;
import com.eventstore.dbclient.UserCredentials;
import java.util.HashMap;
import java.util.Map;

class OptionsBase<T> {
    private Long deadline;
    private final OperationKind kind;
    private UserCredentials credentials;
    private boolean requiresLeader;
    private Map<String, String> headers = new HashMap<String, String>();

    protected OptionsBase() {
        this(OperationKind.Regular);
    }

    protected OptionsBase(OperationKind kind) {
        this.kind = kind;
    }

    boolean hasUserCredentials() {
        return this.credentials != null;
    }

    String getHttpCredentialString() {
        return this.credentials.basicAuthHeader();
    }

    public T authenticated(UserCredentials credentials) {
        this.credentials = credentials;
        return (T)this;
    }

    public T authenticated(String login, String password) {
        return this.authenticated(new UserCredentials(login, password));
    }

    public T requiresLeader() {
        return this.requiresLeader(true);
    }

    public T notRequireLeader() {
        return this.requiresLeader(false);
    }

    public T requiresLeader(boolean value) {
        this.requiresLeader = value;
        return (T)this;
    }

    public T deadline(long durationInMs) {
        this.deadline = durationInMs;
        return (T)this;
    }

    public T header(String key, String value) {
        this.headers.put(key, value);
        return (T)this;
    }

    Long getDeadline() {
        return this.deadline;
    }

    OperationKind getKind() {
        return this.kind;
    }

    boolean isLeaderRequired() {
        return this.requiresLeader;
    }

    UserCredentials getCredentials() {
        return this.credentials;
    }

    Map<String, String> getHeaders() {
        return this.headers;
    }
}

