/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import java.util.Objects;
import javax.validation.constraints.NotNull;

public class Position
implements Comparable<Position> {
    private final long prepare;
    private final long commit;

    public Position(long commitUnsigned, long prepareUnsigned) {
        if (Long.compareUnsigned(commitUnsigned, prepareUnsigned) < 0) {
            throw new IllegalArgumentException("The commit position may not be before the prepare position");
        }
        this.prepare = prepareUnsigned;
        this.commit = commitUnsigned;
    }

    public Position(String prepare, String commit) {
        this(Long.parseUnsignedLong(commit), Long.parseUnsignedLong(prepare));
    }

    public long getPrepareUnsigned() {
        return this.prepare;
    }

    public long getCommitUnsigned() {
        return this.commit;
    }

    public String toString() {
        return String.format("%s/%s", Long.toUnsignedString(this.commit), Long.toUnsignedString(this.prepare));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position position = (Position)o;
        return this.prepare == position.prepare && this.commit == position.commit;
    }

    public int hashCode() {
        return Objects.hash(this.prepare, this.commit);
    }

    @Override
    public int compareTo(@NotNull Position other) {
        if (this.commit == other.commit && this.prepare == other.prepare) {
            return 0;
        }
        if (Long.compareUnsigned(this.commit, other.commit) < 0 || Long.compareUnsigned(this.commit, other.commit) == 0 && Long.compareUnsigned(this.prepare, other.prepare) < 0) {
            return -1;
        }
        return 1;
    }
}

